/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.install.tasks;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.tasks.ListenerTask;
import net.technicpack.launchercore.install.verifiers.SHA1FileVerifier;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.launchercore.util.DownloadListener;
import net.technicpack.minecraftcore.mojang.version.IMinecraftVersionInfo;
import net.technicpack.minecraftcore.mojang.version.io.GameDownloads;
import net.technicpack.utilslib.Utils;

public class InstallMinecraftIfNecessaryTask
extends ListenerTask<IMinecraftVersionInfo> {
    private ModpackModel pack;
    private String minecraftVersion;
    private Path cacheDirectory;
    private boolean forceRegeneration;

    public InstallMinecraftIfNecessaryTask(ModpackModel pack, String minecraftVersion, Path cacheDirectory, boolean forceRegeneration) {
        this.pack = pack;
        this.minecraftVersion = minecraftVersion;
        this.cacheDirectory = cacheDirectory;
        this.forceRegeneration = forceRegeneration;
    }

    @Override
    public String getTaskDescription() {
        return "Installing Minecraft";
    }

    @Override
    public void runTask(InstallTasksQueue<IMinecraftVersionInfo> queue) throws IOException, InterruptedException {
        File targetJar;
        super.runTask(queue);
        IMinecraftVersionInfo version = queue.getMetadata();
        GameDownloads dls = version.getDownloads();
        if (dls == null) {
            throw new RuntimeException("Using legacy Minecraft download! Version id = " + version.getId() + "; parent = " + version.getParentVersion());
        }
        String url = dls.forClient().getUrl();
        SHA1FileVerifier verifier = new SHA1FileVerifier(dls.forClient().getSha1());
        Path originalJar = this.cacheDirectory.resolve(String.format("minecraft_%s.jar", this.minecraftVersion));
        boolean regenerate = this.forceRegeneration;
        if (!Files.isRegularFile(originalJar, new LinkOption[0]) || !verifier.isFileValid(originalJar)) {
            String output = this.pack.getCacheDir() + File.separator + "minecraft.jar";
            Utils.downloadFile(url, originalJar.getFileName().toString(), output, originalJar.toFile(), verifier, this);
            regenerate = true;
        }
        if (!(targetJar = new File(this.pack.getBinDir(), "minecraft.jar")).exists() || regenerate) {
            InstallMinecraftIfNecessaryTask.copyMinecraftJar(originalJar, targetJar.toPath(), this);
        }
    }

    private static void copyMinecraftJar(Path jar, Path output, DownloadListener listener) throws IOException {
        String[] security = new String[]{"MOJANG_C.DSA", "MOJANG_C.SF", "CODESIGN.RSA", "CODESIGN.SF"};
        Pattern securityPattern = Pattern.compile(Arrays.stream(security).map(Pattern::quote).collect(Collectors.joining("|")));
        listener.stateChanged("Processing Minecraft jar", 0.0f);
        try (JarFile jarFile = new JarFile(jar.toFile());
             OutputStream out = Files.newOutputStream(output, new OpenOption[0]);
             JarOutputStream jos = new JarOutputStream(out);){
            Enumeration<JarEntry> entries = jarFile.entries();
            int totalEntries = jarFile.size();
            int x = 0;
            byte[] buffer = new byte[8192];
            while (entries.hasMoreElements()) {
                listener.stateChanged("Processing Minecraft jar", (float)(++x) / (float)totalEntries * 100.0f);
                JarEntry entry = entries.nextElement();
                if (securityPattern.matcher(entry.getName()).find()) continue;
                try (InputStream is = jarFile.getInputStream(entry);){
                    int bytesRead;
                    jos.putNextEntry(new JarEntry(entry.getName()));
                    while ((bytesRead = is.read(buffer)) != -1) {
                        jos.write(buffer, 0, bytesRead);
                    }
                }
                jos.flush();
                jos.closeEntry();
            }
        }
    }
}

