/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.install.tasks;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import net.technicpack.launchercore.exception.DownloadException;
import net.technicpack.launchercore.install.ITasksQueue;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.tasks.CopyFileTask;
import net.technicpack.launchercore.install.tasks.EnsureFileTask;
import net.technicpack.launchercore.install.tasks.IInstallTask;
import net.technicpack.launchercore.install.verifiers.FileSizeVerifier;
import net.technicpack.launchercore.install.verifiers.IFileVerifier;
import net.technicpack.launchercore.install.verifiers.SHA1FileVerifier;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.minecraftcore.MojangUtils;
import net.technicpack.minecraftcore.mojang.version.IMinecraftVersionInfo;
import net.technicpack.utilslib.Utils;

public class InstallMinecraftAssetsTask
implements IInstallTask<IMinecraftVersionInfo> {
    private final ModpackModel modpack;
    private final String assetsDirectory;
    private final Path assetsIndex;
    private final ITasksQueue<IMinecraftVersionInfo> checkAssetsQueue;
    private final ITasksQueue<IMinecraftVersionInfo> downloadAssetsQueue;
    private final ITasksQueue<IMinecraftVersionInfo> copyAssetsQueue;
    private static final String VIRTUAL_FIELD = "virtual";
    private static final String MAP_TO_RESOURCES_FIELD = "map_to_resources";
    private static final String OBJECTS_FIELD = "objects";
    private static final String SIZE_FIELD = "size";
    private static final String HASH_FIELD = "hash";

    public InstallMinecraftAssetsTask(ModpackModel modpack, String assetsDirectory, File assetsIndex, ITasksQueue<IMinecraftVersionInfo> checkAssetsQueue, ITasksQueue<IMinecraftVersionInfo> downloadAssetsQueue, ITasksQueue<IMinecraftVersionInfo> copyAssetsQueue) {
        this.modpack = modpack;
        this.assetsDirectory = assetsDirectory;
        this.assetsIndex = assetsIndex.toPath();
        this.checkAssetsQueue = checkAssetsQueue;
        this.downloadAssetsQueue = downloadAssetsQueue;
        this.copyAssetsQueue = copyAssetsQueue;
    }

    @Override
    public String getTaskDescription() {
        return "Checking Minecraft Assets";
    }

    @Override
    public float getTaskProgress() {
        return 0.0f;
    }

    @Override
    public void runTask(InstallTasksQueue<IMinecraftVersionInfo> queue) throws IOException {
        JsonObject obj = this.readAssetsIndex();
        boolean isVirtual = false;
        if (obj.has(VIRTUAL_FIELD) && obj.get(VIRTUAL_FIELD).isJsonPrimitive()) {
            isVirtual = obj.get(VIRTUAL_FIELD).getAsBoolean();
        }
        boolean mapToResources = false;
        if (obj.has(MAP_TO_RESOURCES_FIELD) && obj.get(MAP_TO_RESOURCES_FIELD).isJsonPrimitive()) {
            mapToResources = obj.get(MAP_TO_RESOURCES_FIELD).getAsBoolean();
        }
        IMinecraftVersionInfo version = queue.getMetadata();
        version.setAreAssetsVirtual(isVirtual);
        version.setAssetsMapToResources(mapToResources);
        JsonObject allAssets = obj.get(OBJECTS_FIELD).getAsJsonObject();
        if (allAssets == null) {
            throw new DownloadException("The assets json file was invalid.");
        }
        String assetsKey = version.getAssetsKey();
        if (assetsKey == null || assetsKey.isEmpty()) {
            assetsKey = "legacy";
        }
        for (Map.Entry<String, JsonElement> assetObj : allAssets.entrySet()) {
            this.processAsset(assetObj, assetsKey, isVirtual, mapToResources);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonObject readAssetsIndex() throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(this.assetsIndex, StandardCharsets.UTF_8);){
            JsonObject jsonObject = MojangUtils.getGson().fromJson((Reader)reader, JsonObject.class);
            if (jsonObject == null) {
                throw new DownloadException(String.format("The assets file %s is invalid", this.assetsIndex));
            }
            JsonObject jsonObject2 = jsonObject;
            return jsonObject2;
        }
        catch (JsonParseException e) {
            throw new IOException(String.format("Failed to load assets index file %s", this.assetsIndex), e);
        }
    }

    private void processAsset(Map.Entry<String, JsonElement> assetObj, String assetsKey, boolean isVirtual, boolean mapToResources) throws IOException {
        IFileVerifier verifier;
        String assetPath = assetObj.getKey();
        JsonObject assetData = assetObj.getValue().getAsJsonObject();
        String hash = assetData.get(HASH_FIELD).getAsString();
        long size = assetData.get(SIZE_FIELD).getAsLong();
        if (hash == null || hash.isEmpty()) {
            throw new DownloadException(String.format("No hash provided for %s", assetPath));
        }
        if (hash.length() == 40) {
            verifier = new SHA1FileVerifier(hash);
        } else {
            Utils.getLogger().warning(String.format("Using file size for validation of asset %s", assetPath));
            verifier = new FileSizeVerifier(size);
        }
        File target = new File(String.format("%s/objects/%s", this.assetsDirectory, hash.substring(0, 2)), hash);
        String url = MojangUtils.getResourceUrl(hash);
        Files.createDirectories(target.getParentFile().toPath(), new FileAttribute[0]);
        File cloneTo = null;
        if (isVirtual) {
            cloneTo = new File(String.format("%s/virtual/%s/%s", this.assetsDirectory, assetsKey, assetPath));
        } else if (mapToResources) {
            cloneTo = new File(this.modpack.getResourcesDir(), assetPath);
        }
        EnsureFileTask<IMinecraftVersionInfo> ensureFileTask = new EnsureFileTask<IMinecraftVersionInfo>(this.downloadAssetsQueue, target).withUrl(url).withVerifier(verifier);
        this.checkAssetsQueue.addTask(ensureFileTask);
        if (cloneTo != null && !cloneTo.exists()) {
            Files.createDirectories(cloneTo.getParentFile().toPath(), new FileAttribute[0]);
            this.copyAssetsQueue.addTask(new CopyFileTask(target, cloneTo));
        }
    }
}

