/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.install.tasks;

import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import net.technicpack.launchercore.exception.DownloadException;
import net.technicpack.launchercore.install.ITasksQueue;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.tasks.EnsureFileTask;
import net.technicpack.launchercore.install.tasks.EnsureLinkedFileTask;
import net.technicpack.launchercore.install.tasks.IInstallTask;
import net.technicpack.launchercore.install.verifiers.SHA1FileVerifier;
import net.technicpack.launchercore.launch.java.IJavaRuntime;
import net.technicpack.launchercore.launch.java.version.FileBasedJavaRuntime;
import net.technicpack.minecraftcore.MojangUtils;
import net.technicpack.minecraftcore.mojang.java.JavaRuntimeFile;
import net.technicpack.minecraftcore.mojang.java.JavaRuntimeFileType;
import net.technicpack.minecraftcore.mojang.java.JavaRuntimeManifest;
import net.technicpack.minecraftcore.mojang.version.IMinecraftVersionInfo;
import net.technicpack.minecraftcore.mojang.version.io.Download;
import net.technicpack.minecraftcore.mojang.version.io.VersionJavaInfo;
import net.technicpack.utilslib.OperatingSystem;
import org.jetbrains.annotations.NotNull;

public class InstallJavaRuntimeTask
implements IInstallTask<IMinecraftVersionInfo> {
    private final Path runtimesDirectory;
    private final Path runtimeManifestFile;
    private final VersionJavaInfo runtimeInfo;
    private final ITasksQueue<IMinecraftVersionInfo> examineJavaQueue;
    private final ITasksQueue<IMinecraftVersionInfo> downloadJavaQueue;

    public InstallJavaRuntimeTask(Path runtimesDirectory, Path runtimeManifestFile, VersionJavaInfo runtimeInfo, ITasksQueue<IMinecraftVersionInfo> examineJavaQueue, ITasksQueue<IMinecraftVersionInfo> downloadJavaQueue) {
        this.runtimesDirectory = runtimesDirectory;
        this.runtimeManifestFile = runtimeManifestFile;
        this.runtimeInfo = runtimeInfo;
        this.examineJavaQueue = examineJavaQueue;
        this.downloadJavaQueue = downloadJavaQueue;
    }

    @Override
    public String getTaskDescription() {
        return "Installing Java runtime";
    }

    @Override
    public float getTaskProgress() {
        return 0.0f;
    }

    @Override
    public void runTask(InstallTasksQueue<IMinecraftVersionInfo> queue) throws IOException {
        JavaRuntimeManifest manifest;
        try (BufferedReader reader = Files.newBufferedReader(this.runtimeManifestFile, StandardCharsets.UTF_8);){
            manifest = MojangUtils.getGson().fromJson((Reader)reader, JavaRuntimeManifest.class);
        }
        catch (JsonParseException e) {
            throw new IOException("Failed to parse Java runtime manifest", e);
        }
        if (manifest == null) {
            throw new DownloadException("The Java runtime manifest is invalid.");
        }
        Path runtimeRoot = this.runtimesDirectory.resolve(this.runtimeInfo.getComponent());
        this.ensurePathIsSafe(this.runtimesDirectory, runtimeRoot);
        Files.createDirectories(runtimeRoot, new FileAttribute[0]);
        this.processDirectories(manifest, runtimeRoot);
        this.processFiles(manifest, runtimeRoot);
        this.processSymlinks(manifest, runtimeRoot);
        IJavaRuntime runtime = InstallJavaRuntimeTask.getJavaRuntime(runtimeRoot);
        IMinecraftVersionInfo version = queue.getMetadata();
        version.setJavaRuntime(runtime);
    }

    private void ensurePathIsSafe(Path root, Path target) {
        Path normalizedRoot = root.normalize();
        Path normalizedTarget = target.normalize();
        if (!normalizedTarget.startsWith(normalizedRoot)) {
            throw new SecurityException(String.format("JRE entry attempted to be placed outside of JRE root folder: %s", target));
        }
    }

    private void processDirectories(JavaRuntimeManifest manifest, Path runtimeRoot) throws IOException {
        for (Map.Entry<String, JavaRuntimeFile> entry : manifest.getFiles().entrySet()) {
            String path = entry.getKey();
            JavaRuntimeFile runtimeFile = entry.getValue();
            if (runtimeFile.getType() != JavaRuntimeFileType.DIRECTORY) continue;
            Path dir = runtimeRoot.resolve(path);
            this.ensurePathIsSafe(runtimeRoot, dir);
            Files.createDirectories(dir, new FileAttribute[0]);
        }
    }

    private void processFiles(JavaRuntimeManifest manifest, Path runtimeRoot) throws IOException {
        for (Map.Entry<String, JavaRuntimeFile> entry : manifest.getFiles().entrySet()) {
            String path = entry.getKey();
            JavaRuntimeFile runtimeFile = entry.getValue();
            if (runtimeFile.getType() != JavaRuntimeFileType.FILE) continue;
            Path target = runtimeRoot.resolve(path);
            this.ensurePathIsSafe(runtimeRoot, target);
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Download rawDownload = runtimeFile.getDownloads().getRaw();
            Download lzmaDownload = runtimeFile.getDownloads().getLzma();
            SHA1FileVerifier verifier = new SHA1FileVerifier(rawDownload.getSha1());
            boolean useLzma = lzmaDownload != null && !lzmaDownload.getUrl().isEmpty() && (double)lzmaDownload.getSize() / (double)rawDownload.getSize() <= 0.66;
            String downloadUrl = useLzma ? lzmaDownload.getUrl() : rawDownload.getUrl();
            EnsureFileTask<IMinecraftVersionInfo> ensureFileTask = new EnsureFileTask<IMinecraftVersionInfo>(this.downloadJavaQueue, target).withUrl(downloadUrl).withVerifier(verifier);
            if (useLzma) {
                ensureFileTask.withDownloadDecompressor("lzma");
            }
            if (runtimeFile.isExecutable()) {
                ensureFileTask.withExecutableBitSet();
            }
            this.examineJavaQueue.addTask(ensureFileTask);
        }
    }

    private void processSymlinks(JavaRuntimeManifest manifest, Path runtimeRoot) {
        for (Map.Entry<String, JavaRuntimeFile> entry : manifest.getFiles().entrySet()) {
            String path = entry.getKey();
            JavaRuntimeFile runtimeFile = entry.getValue();
            if (runtimeFile.getType() != JavaRuntimeFileType.LINK) continue;
            Path link = runtimeRoot.resolve(path);
            this.ensurePathIsSafe(runtimeRoot, link);
            Path target = link.resolve(runtimeFile.getTarget());
            this.ensurePathIsSafe(runtimeRoot, target);
            this.downloadJavaQueue.addTask(new EnsureLinkedFileTask(link, target));
        }
    }

    @NotNull
    private static IJavaRuntime getJavaRuntime(Path runtimeRoot) {
        OperatingSystem os = OperatingSystem.getOperatingSystem();
        Path runtimeExecutable = os == OperatingSystem.WINDOWS ? runtimeRoot.resolve("bin/javaw.exe") : (os == OperatingSystem.OSX ? runtimeRoot.resolve("jre.bundle/Contents/Home/bin/java") : runtimeRoot.resolve("bin/java"));
        return new FileBasedJavaRuntime(runtimeExecutable);
    }
}

