/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.install.tasks;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import net.technicpack.launcher.io.LauncherFileSystem;
import net.technicpack.launchercore.TechnicConstants;
import net.technicpack.launchercore.install.ITasksQueue;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.tasks.CopyFileTask;
import net.technicpack.launchercore.install.tasks.EnsureFileTask;
import net.technicpack.launchercore.install.tasks.IInstallTask;
import net.technicpack.launchercore.install.verifiers.SHA1FileVerifier;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.minecraftcore.FmlLibsManager;
import net.technicpack.minecraftcore.mojang.version.IMinecraftVersionInfo;
import net.technicpack.rest.io.Modpack;

public class InstallFmlLibsTask
implements IInstallTask<IMinecraftVersionInfo> {
    private final ModpackModel pack;
    private final LauncherFileSystem fileSystem;
    private final Modpack modpack;
    private final ITasksQueue<IMinecraftVersionInfo> verifyingFiles;
    private final ITasksQueue<IMinecraftVersionInfo> downloadLibraryQueue;
    private final ITasksQueue<IMinecraftVersionInfo> copyLibraryQueue;

    public InstallFmlLibsTask(ModpackModel pack, LauncherFileSystem fileSystem, Modpack modpack, ITasksQueue<IMinecraftVersionInfo> verifyingFiles, ITasksQueue<IMinecraftVersionInfo> downloadLibraryQueue, ITasksQueue<IMinecraftVersionInfo> copyLibraryQueue) {
        this.pack = pack;
        this.fileSystem = fileSystem;
        this.modpack = modpack;
        this.verifyingFiles = verifyingFiles;
        this.downloadLibraryQueue = downloadLibraryQueue;
        this.copyLibraryQueue = copyLibraryQueue;
    }

    @Override
    public String getTaskDescription() {
        return "Installing FML libraries";
    }

    @Override
    public float getTaskProgress() {
        return 0.0f;
    }

    @Override
    public void runTask(InstallTasksQueue<IMinecraftVersionInfo> queue) throws IOException, InterruptedException {
        String minecraft = this.modpack.getGameVersion();
        Map<String, String> fmlLibs = FmlLibsManager.getLibsForVersion(minecraft);
        if (fmlLibs.isEmpty()) {
            return;
        }
        Path fmlLibsCache = this.fileSystem.getCacheDirectory().resolve("fmllibs");
        Files.createDirectories(fmlLibsCache, new FileAttribute[0]);
        File modpackFmlLibDir = new File(this.pack.getInstalledDirectory(), "lib");
        fmlLibs.forEach((name, sha1) -> {
            SHA1FileVerifier verifier = null;
            if (!sha1.isEmpty()) {
                verifier = new SHA1FileVerifier((String)sha1);
            }
            File cached = fmlLibsCache.resolve((String)name).toFile();
            File target = new File(modpackFmlLibDir, (String)name);
            if (!target.exists() || verifier != null && !verifier.isFileValid(target)) {
                EnsureFileTask<IMinecraftVersionInfo> ensureFileTask = new EnsureFileTask<IMinecraftVersionInfo>(this.downloadLibraryQueue, cached).withUrl(TechnicConstants.TECHNIC_FML_LIB_REPO + name).withVerifier(verifier);
                this.verifyingFiles.addTask(ensureFileTask);
                this.copyLibraryQueue.addTask(new CopyFileTask(cached, target));
            }
        });
    }
}

