/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.install.tasks;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import net.technicpack.launcher.io.LauncherFileSystem;
import net.technicpack.launchercore.TechnicConstants;
import net.technicpack.launchercore.exception.DownloadException;
import net.technicpack.launchercore.install.ITasksQueue;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.tasks.IInstallTask;
import net.technicpack.launchercore.launch.java.IJavaRuntime;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.minecraftcore.MojangUtils;
import net.technicpack.minecraftcore.install.tasks.InstallVersionLibTask;
import net.technicpack.minecraftcore.launch.ILaunchOptions;
import net.technicpack.minecraftcore.mojang.version.IMinecraftVersionInfo;
import net.technicpack.minecraftcore.mojang.version.MinecraftVersionInfoBuilder;
import net.technicpack.minecraftcore.mojang.version.io.Artifact;
import net.technicpack.minecraftcore.mojang.version.io.Downloads;
import net.technicpack.minecraftcore.mojang.version.io.Library;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class HandleVersionFileTask
implements IInstallTask<IMinecraftVersionInfo> {
    private ModpackModel pack;
    private LauncherFileSystem fileSystem;
    private ITasksQueue<IMinecraftVersionInfo> checkLibraryQueue;
    private ITasksQueue<IMinecraftVersionInfo> downloadLibraryQueue;
    private ITasksQueue<IMinecraftVersionInfo> copyLibraryQueue;
    private ITasksQueue<IMinecraftVersionInfo> checkNonMavenLibsQueue;
    private MinecraftVersionInfoBuilder versionBuilder;
    private ILaunchOptions launchOptions;
    private IJavaRuntime javaRuntime;
    private String libraryName;

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    public HandleVersionFileTask withPack(ModpackModel pack) {
        this.pack = pack;
        return this;
    }

    public HandleVersionFileTask withFileSystem(LauncherFileSystem fileSystem) {
        this.fileSystem = fileSystem;
        return this;
    }

    public HandleVersionFileTask withCheckLibraryQueue(ITasksQueue<IMinecraftVersionInfo> checkLibraryQueue) {
        this.checkLibraryQueue = checkLibraryQueue;
        return this;
    }

    public HandleVersionFileTask withDownloadLibraryQueue(ITasksQueue<IMinecraftVersionInfo> downloadLibraryQueue) {
        this.downloadLibraryQueue = downloadLibraryQueue;
        return this;
    }

    public HandleVersionFileTask withCopyLibraryQueue(ITasksQueue<IMinecraftVersionInfo> copyLibraryQueue) {
        this.copyLibraryQueue = copyLibraryQueue;
        return this;
    }

    public HandleVersionFileTask withCheckNonMavenLibsQueue(ITasksQueue<IMinecraftVersionInfo> checkNonMavenLibsQueue) {
        this.checkNonMavenLibsQueue = checkNonMavenLibsQueue;
        return this;
    }

    public HandleVersionFileTask withVersionBuilder(MinecraftVersionInfoBuilder versionBuilder) {
        this.versionBuilder = versionBuilder;
        return this;
    }

    public HandleVersionFileTask withLaunchOptions(ILaunchOptions launchOptions) {
        this.launchOptions = launchOptions;
        return this;
    }

    public HandleVersionFileTask withJavaRuntime(IJavaRuntime javaRuntime) {
        this.javaRuntime = javaRuntime;
        return this;
    }

    @Override
    public String getTaskDescription() {
        if (this.libraryName == null) {
            return "Processing version.";
        }
        return "Verifying " + this.libraryName + ".";
    }

    @Override
    public float getTaskProgress() {
        return 0.0f;
    }

    @Override
    public void runTask(InstallTasksQueue<IMinecraftVersionInfo> queue) throws IOException, InterruptedException {
        Objects.requireNonNull(this.pack, "ModpackModel must be set.");
        Objects.requireNonNull(this.fileSystem, "LauncherFileSystem must be set.");
        Objects.requireNonNull(this.checkLibraryQueue, "CheckLibraryQueue must be set.");
        Objects.requireNonNull(this.downloadLibraryQueue, "DownloadLibraryQueue must be set.");
        Objects.requireNonNull(this.copyLibraryQueue, "CopyLibraryQueue must be set.");
        Objects.requireNonNull(this.checkNonMavenLibsQueue, "CheckNonMavenLibsQueue must be set.");
        Objects.requireNonNull(this.versionBuilder, "VersionBuilder must be set.");
        Objects.requireNonNull(this.launchOptions, "LaunchOptions must be set.");
        Objects.requireNonNull(this.javaRuntime, "JavaRuntime must be set.");
        IMinecraftVersionInfo version = this.versionBuilder.buildVersionFromKey(null);
        if (version == null) {
            throw new DownloadException("The version.json file was invalid.");
        }
        version.setJavaRuntime(this.javaRuntime);
        boolean isLegacy = MojangUtils.isLegacyVersion(version.getParentVersion());
        if (isLegacy) {
            Library legacyWrapper = new Library("net.technicpack:legacywrapper:1.2.1", TechnicConstants.TECHNIC_LIB_REPO + "net/technicpack/legacywrapper/1.2.1/legacywrapper-1.2.1.jar", "741cbc946421a5a59188a51108e1ce5cb5674681", 77327);
            version.addLibrary(legacyWrapper);
            version.setMainClass("net.technicpack.legacywrapper.Launch");
        }
        boolean hasNeoForge = MojangUtils.hasNeoForge(version);
        boolean hasModernMinecraftForge = MojangUtils.hasModernMinecraftForge(version);
        if (hasModernMinecraftForge || hasNeoForge) {
            List installerLibraries;
            Iterator oldName;
            String[] versionIdParts = version.getId().split("-", 3);
            boolean is1_12_2 = versionIdParts[0].equals("1.12.2");
            if (is1_12_2) {
                for (Library library : version.getLibrariesForCurrentOS(this.launchOptions, this.javaRuntime)) {
                    if (!library.getGradleGroup().equals("net.minecraftforge") || !library.getGradleArtifact().equals("forge") || library.getGradleClassifier() != null && !library.getGradleClassifier().isEmpty()) continue;
                    oldName = library.getName();
                    library.setName(library.getName() + ":universal");
                    Downloads downloads = library.getDownloads();
                    Artifact artifact = downloads.getArtifact();
                    artifact.setUrl("https://maven.minecraftforge.net/" + library.getArtifactPath());
                    library.setName((String)((Object)oldName));
                    break;
                }
            }
            try {
                JarFile modpackJar = new JarFile(new File(this.pack.getBinDir(), "modpack.jar"));
                oldName = null;
                try {
                    JarEntry entry = modpackJar.getJarEntry("install_profile.json");
                    if (entry == null) {
                        throw new RuntimeException("modpack.jar does not contain the install_profile.json file");
                    }
                    try (InputStream inputStream = modpackJar.getInputStream(entry);){
                        InputStreamReader reader = new InputStreamReader(inputStream);
                        Object object = null;
                        try {
                            JsonElement root = JsonParser.parseReader(reader);
                            JsonObject rootObj = root.getAsJsonObject();
                            JsonElement librariesElement = rootObj.get("libraries");
                            if (librariesElement == null || !librariesElement.isJsonArray()) {
                                throw new RuntimeException("install_profile.json does not contain libraries");
                            }
                            installerLibraries = (List)MojangUtils.getGson().fromJson(librariesElement, new TypeToken<List<Library>>(){}.getType());
                        }
                        catch (Throwable throwable) {
                            object = throwable;
                            throw throwable;
                        }
                        finally {
                            if (reader != null) {
                                if (object != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)object).addSuppressed(throwable);
                                    }
                                } else {
                                    reader.close();
                                }
                            }
                        }
                    }
                }
                catch (Throwable entry) {
                    oldName = entry;
                    throw entry;
                }
                finally {
                    if (modpackJar != null) {
                        if (oldName != null) {
                            try {
                                modpackJar.close();
                            }
                            catch (Throwable entry) {
                                ((Throwable)((Object)oldName)).addSuppressed(entry);
                            }
                        } else {
                            modpackJar.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to extract libraries from install_profile.json", e);
            }
            List dedupedInstallerLibraries = installerLibraries.stream().filter(HandleVersionFileTask.distinctByKey(Library::getName)).collect(Collectors.toList());
            for (Object library : dedupedInstallerLibraries) {
                Downloads downloads;
                Artifact artifact;
                if (((Library)library).isMinecraftForge() && is1_12_2) continue;
                if (((Library)library).getGradleGroup().equals("net.minecraftforge") && ((Library)library).getGradleArtifact().equals("forge") && ((Library)library).getGradleClassifier() != null && ((Library)library).getGradleClassifier().equals("universal") && !is1_12_2 && ((artifact = (downloads = ((Library)library).getDownloads()).getArtifact()).getUrl() == null || artifact.getUrl().isEmpty())) {
                    artifact.setUrl("https://maven.minecraftforge.net/" + ((Library)library).getArtifactPath());
                }
                this.checkLibraryQueue.addTask(new InstallVersionLibTask((Library)library, this.checkNonMavenLibsQueue, this.downloadLibraryQueue, this.copyLibraryQueue, this.pack, this.fileSystem));
            }
            if (!is1_12_2) {
                Library forgeWrapper = new Library("io.github.zekerzhayard:ForgeWrapper:1.6.0-technic", TechnicConstants.TECHNIC_LIB_REPO + "io/github/zekerzhayard/ForgeWrapper/1.6.0-technic/ForgeWrapper-1.6.0-technic.jar", "8764cbf4c7ded7ac0ad9136a0070bbfeee8813cf", 34944);
                version.prependLibrary(forgeWrapper);
                version.setMainClass("io.github.zekerzhayard.forgewrapper.installer.Main");
                for (Library library : version.getLibrariesForCurrentOS(this.launchOptions, this.javaRuntime)) {
                    if (library.getGradleGroup().equals("net.minecraftforge") && library.getGradleArtifact().equals("forge") && (library.getGradleClassifier() == null || library.getGradleClassifier().isEmpty())) {
                        String oldName2 = library.getName();
                        library.setName(library.getName() + ":launcher");
                        Downloads downloads = library.getDownloads();
                        Artifact artifact = downloads.getArtifact();
                        if (artifact.getUrl() == null || artifact.getUrl().isEmpty()) {
                            artifact.setUrl("https://maven.minecraftforge.net/" + library.getArtifactPath());
                        }
                        library.setName(oldName2);
                        break;
                    }
                    if (!library.getGradleGroup().equals("net.minecraftforge") || !library.getGradleArtifact().equals("forge") || library.getGradleClassifier() == null || !library.getGradleClassifier().equals("client")) continue;
                    version.removeLibrary(library.getName());
                }
            }
        }
        for (Library library : version.getLibrariesForCurrentOS(this.launchOptions, this.javaRuntime)) {
            if (library.isMinecraftForge() && !hasModernMinecraftForge) {
                version.removeLibrary(library.getName());
                continue;
            }
            if (isLegacy && library.getName().startsWith("net.minecraft:launchwrapper:")) {
                version.removeLibrary(library.getName());
                continue;
            }
            if (library.isLog4j() && new ComparableVersion(library.getGradleVersion()).compareTo(new ComparableVersion("2.16.0")) < 0) {
                int size;
                String sha1;
                String[] libNameParts = library.getName().split(":");
                String log4jVersion = "2.16.0";
                if (libNameParts[2].equals("2.0-beta9")) {
                    log4jVersion = "2.0-beta9-fixed";
                }
                String artifactName = libNameParts[1];
                block17 : switch (log4jVersion) {
                    case "2.16.0": {
                        switch (artifactName) {
                            case "log4j-api": {
                                sha1 = "f821a18687126c2e2f227038f540e7953ad2cc8c";
                                size = 301892;
                                break block17;
                            }
                            case "log4j-core": {
                                sha1 = "539a445388aee52108700f26d9644989e7916e7c";
                                size = 1789565;
                                break block17;
                            }
                            case "log4j-slf4j18-impl": {
                                sha1 = "0c880a059056df5725f5d8d1035276d9749eba6d";
                                size = 21249;
                                break block17;
                            }
                        }
                        throw new RuntimeException("Unknown log4j artifact " + artifactName + ", cannot continue");
                    }
                    case "2.0-beta9-fixed": {
                        switch (artifactName) {
                            case "log4j-api": {
                                sha1 = "b61eaf2e64d8b0277e188262a8b771bbfa1502b3";
                                size = 107347;
                                break block17;
                            }
                            case "log4j-core": {
                                sha1 = "677991ea2d7426f76309a73739cecf609679492c";
                                size = 677588;
                                break block17;
                            }
                        }
                        throw new RuntimeException("Unknown log4j artifact " + artifactName + ", cannot continue");
                    }
                    default: {
                        throw new RuntimeException("Unknown log4j version " + log4jVersion + ", cannot continue");
                    }
                }
                String url = String.format(TechnicConstants.TECHNIC_LIB_REPO + "org/apache/logging/log4j/%1$s/%2$s/%1$s-%2$s.jar", artifactName, log4jVersion);
                Library fixedLog4j = new Library("org.apache.logging.log4j:" + artifactName + ":" + log4jVersion, url, sha1, size);
                version.addLibrary(fixedLog4j);
                this.checkLibraryQueue.addTask(new InstallVersionLibTask(fixedLog4j, this.checkNonMavenLibsQueue, this.downloadLibraryQueue, this.copyLibraryQueue, this.pack, this.fileSystem));
                version.removeLibrary(library.getName());
                continue;
            }
            this.checkLibraryQueue.addTask(new InstallVersionLibTask(library, this.checkNonMavenLibsQueue, this.downloadLibraryQueue, this.copyLibraryQueue, this.pack, this.fileSystem));
        }
        queue.setMetadata(version);
    }
}

