/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.install.tasks;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.technicpack.launchercore.exception.DownloadException;
import net.technicpack.launchercore.install.ITasksQueue;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.tasks.DownloadFileTask;
import net.technicpack.launchercore.install.tasks.IInstallTask;
import net.technicpack.launchercore.install.verifiers.SHA1FileVerifier;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.minecraftcore.MojangUtils;
import net.technicpack.minecraftcore.install.tasks.InstallJavaRuntimeTask;
import net.technicpack.minecraftcore.mojang.java.JavaRuntime;
import net.technicpack.minecraftcore.mojang.java.JavaRuntimesIndex;
import net.technicpack.minecraftcore.mojang.version.IMinecraftVersionInfo;
import net.technicpack.minecraftcore.mojang.version.io.Download;
import net.technicpack.minecraftcore.mojang.version.io.VersionJavaInfo;

public class EnsureJavaRuntimeManifestTask
implements IInstallTask<IMinecraftVersionInfo> {
    private final Path runtimesDirectory;
    private final ModpackModel modpack;
    private final ITasksQueue<IMinecraftVersionInfo> fetchJavaManifest;
    private final ITasksQueue<IMinecraftVersionInfo> examineJavaQueue;
    private final ITasksQueue<IMinecraftVersionInfo> downloadJavaQueue;

    public EnsureJavaRuntimeManifestTask(Path runtimesDirectory, ModpackModel modpack, ITasksQueue<IMinecraftVersionInfo> fetchJavaManifest, ITasksQueue<IMinecraftVersionInfo> examineJavaQueue, ITasksQueue<IMinecraftVersionInfo> downloadJavaQueue) {
        this.runtimesDirectory = runtimesDirectory;
        this.modpack = modpack;
        this.fetchJavaManifest = fetchJavaManifest;
        this.examineJavaQueue = examineJavaQueue;
        this.downloadJavaQueue = downloadJavaQueue;
    }

    @Override
    public String getTaskDescription() {
        return "Retrieving Java runtime manifest";
    }

    @Override
    public float getTaskProgress() {
        return 0.0f;
    }

    @Override
    public void runTask(InstallTasksQueue<IMinecraftVersionInfo> queue) throws IOException {
        IMinecraftVersionInfo version = queue.getMetadata();
        VersionJavaInfo runtimeInfo = version.getMojangRuntimeInformation();
        if (runtimeInfo == null) {
            return;
        }
        String runtimeName = runtimeInfo.getComponent();
        JavaRuntimesIndex availableRuntimes = MojangUtils.getJavaRuntimesIndex(this.runtimesDirectory.resolve("_index.json"));
        if (availableRuntimes == null) {
            throw new DownloadException("Failed to get Mojang JRE information");
        }
        JavaRuntime manifest = availableRuntimes.getRuntimeForCurrentOS(runtimeName);
        if (manifest == null) {
            throw new DownloadException("A Mojang JRE is not available for the current OS");
        }
        Download runtimeDownload = manifest.getManifest();
        Path output = this.runtimesDirectory.resolve("manifests").resolve(runtimeName + ".json");
        Files.createDirectories(output.getParent(), new FileAttribute[0]);
        SHA1FileVerifier fileVerifier = new SHA1FileVerifier(runtimeDownload.getSha1());
        if (!Files.isRegularFile(output, new LinkOption[0]) || !fileVerifier.isFileValid(output)) {
            this.fetchJavaManifest.addTask(new DownloadFileTask(runtimeDownload.getUrl(), output.toFile(), fileVerifier));
        }
        this.examineJavaQueue.addTask(new InstallJavaRuntimeTask(this.runtimesDirectory, output, runtimeInfo, this.examineJavaQueue, this.downloadJavaQueue));
    }
}

