/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.install.tasks;

import java.io.File;
import net.technicpack.launchercore.install.ITasksQueue;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.tasks.DownloadFileTask;
import net.technicpack.launchercore.install.tasks.IInstallTask;
import net.technicpack.launchercore.install.verifiers.IFileVerifier;
import net.technicpack.launchercore.install.verifiers.SHA1FileVerifier;
import net.technicpack.launchercore.install.verifiers.ValidJsonFileVerifier;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.minecraftcore.MojangUtils;
import net.technicpack.minecraftcore.install.tasks.InstallMinecraftAssetsTask;
import net.technicpack.minecraftcore.mojang.version.IMinecraftVersionInfo;
import net.technicpack.minecraftcore.mojang.version.io.AssetIndex;

public class EnsureAssetsIndexTask
implements IInstallTask<IMinecraftVersionInfo> {
    private final File assetsDirectory;
    private final ModpackModel modpack;
    private final ITasksQueue<IMinecraftVersionInfo> downloadIndexQueue;
    private final ITasksQueue<IMinecraftVersionInfo> examineIndexQueue;
    private final ITasksQueue<IMinecraftVersionInfo> checkAssetsQueue;
    private final ITasksQueue<IMinecraftVersionInfo> downloadAssetsQueue;
    private final ITasksQueue<IMinecraftVersionInfo> installAssetsQueue;

    public EnsureAssetsIndexTask(File assetsDirectory, ModpackModel modpack, ITasksQueue<IMinecraftVersionInfo> downloadIndexQueue, ITasksQueue<IMinecraftVersionInfo> examineIndexQueue, ITasksQueue<IMinecraftVersionInfo> checkAssetsQueue, ITasksQueue<IMinecraftVersionInfo> downloadAssetsQueue, ITasksQueue<IMinecraftVersionInfo> installAssetsQueue) {
        this.assetsDirectory = assetsDirectory;
        this.modpack = modpack;
        this.downloadIndexQueue = downloadIndexQueue;
        this.examineIndexQueue = examineIndexQueue;
        this.checkAssetsQueue = checkAssetsQueue;
        this.downloadAssetsQueue = downloadAssetsQueue;
        this.installAssetsQueue = installAssetsQueue;
    }

    @Override
    public String getTaskDescription() {
        return "Retrieving assets index";
    }

    @Override
    public float getTaskProgress() {
        return 0.0f;
    }

    @Override
    public void runTask(InstallTasksQueue<IMinecraftVersionInfo> queue) {
        IMinecraftVersionInfo version = queue.getMetadata();
        AssetIndex assetIndex = version.getAssetIndex();
        if (assetIndex == null) {
            throw new RuntimeException("No asset index detected, cannot continue");
        }
        String assetsUrl = assetIndex.getUrl();
        File assetsFile = new File(this.assetsDirectory + File.separator + "indexes", assetIndex.getId() + ".json");
        new File(assetsFile.getParent()).mkdirs();
        IFileVerifier fileVerifier = assetIndex.getSha1() != null ? new SHA1FileVerifier(assetIndex.getSha1()) : new ValidJsonFileVerifier(MojangUtils.getGson());
        if (!assetsFile.exists() || !fileVerifier.isFileValid(assetsFile)) {
            this.downloadIndexQueue.addTask(new DownloadFileTask(assetsUrl, assetsFile, fileVerifier));
        }
        this.examineIndexQueue.addTask(new InstallMinecraftAssetsTask(this.modpack, this.assetsDirectory.getAbsolutePath(), assetsFile, this.checkAssetsQueue, this.downloadAssetsQueue, this.installAssetsQueue));
    }
}

