/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore.install.tasks;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.regex.Pattern;
import net.technicpack.launchercore.exception.CacheDeleteException;
import net.technicpack.launchercore.install.ITasksQueue;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.tasks.EnsureFileTask;
import net.technicpack.launchercore.install.tasks.IInstallTask;
import net.technicpack.launchercore.install.verifiers.IFileVerifier;
import net.technicpack.launchercore.install.verifiers.MD5FileVerifier;
import net.technicpack.launchercore.install.verifiers.ValidZipFileVerifier;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.minecraftcore.install.ModpackZipFilter;
import net.technicpack.minecraftcore.install.tasks.CleanupModpackCacheTask;
import net.technicpack.minecraftcore.mojang.version.IMinecraftVersionInfo;
import net.technicpack.rest.io.Mod;
import net.technicpack.rest.io.Modpack;

public class CleanupAndExtractModpackTask
implements IInstallTask<IMinecraftVersionInfo> {
    private final ModpackModel pack;
    private final Modpack modpack;
    private final ITasksQueue<IMinecraftVersionInfo> checkModQueue;
    private final ITasksQueue<IMinecraftVersionInfo> downloadModQueue;
    private final ITasksQueue<IMinecraftVersionInfo> copyModQueue;

    public CleanupAndExtractModpackTask(ModpackModel pack, Modpack modpack, ITasksQueue<IMinecraftVersionInfo> checkModQueue, ITasksQueue<IMinecraftVersionInfo> downloadModQueue, ITasksQueue<IMinecraftVersionInfo> copyModQueue) {
        this.pack = pack;
        this.modpack = modpack;
        this.checkModQueue = checkModQueue;
        this.downloadModQueue = downloadModQueue;
        this.copyModQueue = copyModQueue;
    }

    @Override
    public String getTaskDescription() {
        return "Wiping Folders";
    }

    @Override
    public float getTaskProgress() {
        return 0.0f;
    }

    @Override
    public void runTask(InstallTasksQueue<IMinecraftVersionInfo> queue) throws IOException {
        File binDir = this.pack.getBinDir();
        File versionFile = new File(binDir, "version.json");
        this.removeFile(versionFile);
        File installProfileFile = new File(binDir, "install_profile.json");
        this.removeFile(installProfileFile);
        File[] binFiles = binDir.listFiles();
        if (binFiles != null) {
            Pattern minecraftVersionPattern = Pattern.compile("^\\d++(\\.\\d++)++\\.json$");
            for (File binFile : binFiles) {
                if (!minecraftVersionPattern.matcher(binFile.getName()).matches()) continue;
                this.removeFile(binFile);
            }
        }
        File runData = new File(binDir, "runData");
        this.removeFile(runData);
        File modpackJar = new File(binDir, "modpack.jar");
        this.removeFile(modpackJar);
        this.deleteMods(this.pack.getModsDir());
        this.deleteMods(this.pack.getCoremodsDir());
        File modpackInstallDirectory = this.pack.getInstalledDirectory();
        File flansDir = new File(modpackInstallDirectory, "Flan");
        this.deleteMods(flansDir);
        ModpackZipFilter zipFilter = new ModpackZipFilter(this.pack);
        File cacheDir = this.pack.getCacheDir();
        ArrayList<File> processedFiles = new ArrayList<File>(this.modpack.getMods().size());
        for (Mod mod : this.modpack.getMods()) {
            String url = mod.getUrl();
            String md5 = mod.getMd5();
            File cacheFile = mod.generateSafeCacheFile(cacheDir);
            if (processedFiles.contains(cacheFile)) {
                throw new IOException("Detected overlapping files for modpack " + this.pack.getName() + ": " + cacheFile.getName());
            }
            processedFiles.add(cacheFile);
            IFileVerifier verifier = md5 != null && !md5.isEmpty() ? new MD5FileVerifier(md5) : new ValidZipFileVerifier();
            EnsureFileTask<IMinecraftVersionInfo> ensureFileTask = new EnsureFileTask<IMinecraftVersionInfo>(this.downloadModQueue, cacheFile).withUrl(url).withVerifier(verifier).withExtractTo(modpackInstallDirectory, this.copyModQueue).withZipFilter(zipFilter);
            this.checkModQueue.addTask(ensureFileTask);
        }
        this.copyModQueue.addTask(new CleanupModpackCacheTask(this.pack, this.modpack));
    }

    private void deleteMods(File modsDir) throws CacheDeleteException {
        if (modsDir == null || !modsDir.exists() || !modsDir.isDirectory()) {
            return;
        }
        for (File mod : modsDir.listFiles()) {
            if (mod.isDirectory()) {
                this.deleteMods(mod);
                continue;
            }
            if (!mod.getName().endsWith(".zip") && !mod.getName().endsWith(".jar") && !mod.getName().endsWith(".litemod")) continue;
            this.removeFile(mod);
        }
    }

    private void removeFile(File file) throws CacheDeleteException {
        if (file.exists()) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                throw new CacheDeleteException(file.getAbsolutePath(), e);
            }
        }
    }
}

