/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.minecraftcore;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.v5.Apache5HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.gson.GsonFactory;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.technicpack.launcher.io.IUserTypeInstanceCreator;
import net.technicpack.launchercore.auth.IUserType;
import net.technicpack.minecraftcore.mojang.java.JavaRuntimesIndex;
import net.technicpack.minecraftcore.mojang.version.IMinecraftVersionInfo;
import net.technicpack.minecraftcore.mojang.version.io.MinecraftVersionInfo;
import net.technicpack.minecraftcore.mojang.version.io.MinecraftVersionInfoDeserializer;
import net.technicpack.minecraftcore.mojang.version.io.Rule;
import net.technicpack.minecraftcore.mojang.version.io.RuleAdapter;
import net.technicpack.minecraftcore.mojang.version.io.argument.ArgumentList;
import net.technicpack.minecraftcore.mojang.version.io.argument.ArgumentListAdapter;
import net.technicpack.utilslib.DateTypeAdapter;
import net.technicpack.utilslib.LowerCaseEnumTypeAdapterFactory;
import net.technicpack.utilslib.Utils;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class MojangUtils {
    private static final HttpTransport HTTP_TRANSPORT = new Apache5HttpTransport();
    private static final JsonFactory JSON_FACTORY = new GsonFactory();
    private static final HttpRequestFactory REQUEST_FACTORY;
    public static final String assets = "https://resources.download.minecraft.net/";
    public static final String RUNTIMES_URL = "https://launchermeta.mojang.com/v1/products/java-runtime/2ec0cc96c44e5a76b9c8b7c39df7210883d12871/all.json";
    private static JavaRuntimesIndex javaRuntimesIndex;
    private static final Gson gson;

    public static String getResourceUrl(String hash) {
        return assets + hash.substring(0, 2) + "/" + hash;
    }

    public static Gson getGson() {
        return gson;
    }

    public static boolean isLegacyVersion(String version) {
        String[] versionParts = version.split("[.-]", 3);
        return Integer.parseInt(versionParts[0]) == 1 && Integer.parseInt(versionParts[1]) < 6;
    }

    public static boolean hasModernMinecraftForge(IMinecraftVersionInfo version) {
        Pattern p = Pattern.compile("^(?<mc>[0-9.]+)-forge-(?<forge>[0-9.]+)$");
        Matcher m = p.matcher(version.getId());
        if (!m.matches()) {
            return false;
        }
        String mcVersionString = m.group("mc");
        ComparableVersion mcVersion = new ComparableVersion(mcVersionString);
        ComparableVersion forgeVersion = new ComparableVersion(m.group("forge"));
        if (mcVersion.compareTo(new ComparableVersion("1.13")) >= 0) {
            return true;
        }
        return mcVersionString.equals("1.12.2") && forgeVersion.compareTo(new ComparableVersion("14.23.5.2847")) > 0;
    }

    public static boolean hasNeoForge(IMinecraftVersionInfo version) {
        Pattern p = Pattern.compile("^neoforge-(?<forge>[0-9.]+)");
        Matcher m = p.matcher(version.getId());
        return m.lookingAt();
    }

    public static String getMinecraftVersion(IMinecraftVersionInfo version) {
        String id = version.getId();
        if (!id.contains("-")) {
            return id;
        }
        if (MojangUtils.hasNeoForge(version)) {
            return version.getParentVersion();
        }
        String[] idParts = id.split("-");
        return idParts[0];
    }

    public static boolean requiresForgeWrapper(IMinecraftVersionInfo version) {
        if (MojangUtils.hasNeoForge(version)) {
            return true;
        }
        if (!MojangUtils.hasModernMinecraftForge(version)) {
            return false;
        }
        String mcVersion = MojangUtils.getMinecraftVersion(version);
        return !mcVersion.equals("1.12.2");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JavaRuntimesIndex getJavaRuntimesIndex(Path cachedIndexPath) {
        if (javaRuntimesIndex != null) {
            return javaRuntimesIndex;
        }
        try {
            HttpRequest request = REQUEST_FACTORY.buildGetRequest(new GenericUrl(RUNTIMES_URL));
            HttpResponse httpResponse = request.execute();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(httpResponse.getContent(), StandardCharsets.UTF_8));){
                javaRuntimesIndex = gson.fromJson((Reader)reader, JavaRuntimesIndex.class);
                try (BufferedWriter writer = Files.newBufferedWriter(cachedIndexPath, StandardCharsets.UTF_8, new OpenOption[0]);){
                    gson.toJson((Object)javaRuntimesIndex, (Appendable)writer);
                }
                catch (IOException ex) {
                    Utils.getLogger().log(Level.WARNING, "Failed to save Java runtimes index to cache", ex);
                }
                JavaRuntimesIndex throwable5 = javaRuntimesIndex;
                return throwable5;
            }
        }
        catch (JsonParseException | IOException e) {
            Utils.getLogger().log(Level.SEVERE, "Failed to get Java runtimes index", e);
            if (!Files.exists(cachedIndexPath, new LinkOption[0])) {
                Utils.getLogger().log(Level.SEVERE, "No cached Java runtimes index found");
                return null;
            }
            Utils.getLogger().log(Level.WARNING, "Using cached Java runtimes index");
            try (BufferedReader reader2 = Files.newBufferedReader(cachedIndexPath, StandardCharsets.UTF_8);){
                JavaRuntimesIndex javaRuntimesIndex = gson.fromJson((Reader)reader2, JavaRuntimesIndex.class);
                return javaRuntimesIndex;
            }
            catch (IOException ex) {
                Utils.getLogger().log(Level.SEVERE, "Failed to load Java runtimes index from cache", ex);
                return null;
            }
        }
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapterFactory(new LowerCaseEnumTypeAdapterFactory());
        builder.registerTypeAdapter((Type)((Object)Date.class), new DateTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)ArgumentList.class), new ArgumentListAdapter());
        builder.registerTypeAdapter((Type)((Object)Rule.class), new RuleAdapter());
        builder.registerTypeAdapter((Type)((Object)IUserType.class), new IUserTypeInstanceCreator());
        builder.registerTypeAdapter((Type)((Object)MinecraftVersionInfo.class), new MinecraftVersionInfoDeserializer());
        builder.enableComplexMapKeySerialization();
        builder.setPrettyPrinting();
        gson = builder.create();
        REQUEST_FACTORY = HTTP_TRANSPORT.createRequestFactory(request -> request.setParser(new JsonObjectParser(JSON_FACTORY)));
    }
}

