/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.modpacks.sources;

import java.util.Collection;
import java.util.LinkedList;
import net.technicpack.launchercore.modpacks.MemoryModpackContainer;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.launchercore.modpacks.sources.IPackSource;
import net.technicpack.rest.io.PackInfo;

public class NameFilterPackSource
implements IPackSource {
    private MemoryModpackContainer baseModpacks;
    private String filterTerms;

    public NameFilterPackSource(MemoryModpackContainer modpacks, String filter) {
        this.baseModpacks = modpacks;
        this.filterTerms = filter.toUpperCase();
    }

    @Override
    public String getSourceName() {
        return "Installed packs filtered by '" + this.filterTerms + "'";
    }

    @Override
    public Collection<PackInfo> getPublicPacks() {
        LinkedList<PackInfo> info = new LinkedList<PackInfo>();
        for (ModpackModel modpack : this.baseModpacks.getModpacks()) {
            if (!modpack.getDisplayName().toUpperCase().contains(this.filterTerms)) continue;
            info.add(modpack.getPackInfo());
        }
        return info;
    }

    @Override
    public int getPriority(PackInfo info) {
        for (ModpackModel modpack : this.baseModpacks.getModpacks()) {
            if (!modpack.getName().equals(info.getName())) continue;
            return modpack.getPriority();
        }
        return 0;
    }
}

