/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.modpacks.resources;

import java.awt.image.BufferedImage;
import java.io.File;
import net.technicpack.launcher.io.LauncherFileSystem;
import net.technicpack.launchercore.image.IImageMapper;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.launchercore.modpacks.resources.resourcetype.IModpackResourceType;
import net.technicpack.rest.io.Resource;
import net.technicpack.utilslib.CryptoUtils;

public class PackResourceMapper
implements IImageMapper<ModpackModel> {
    private LauncherFileSystem fileSystem;
    private BufferedImage defaultImage;
    private IModpackResourceType resourceType;

    public PackResourceMapper(LauncherFileSystem fileSystem, BufferedImage defaultImage, IModpackResourceType resourceType) {
        this.fileSystem = fileSystem;
        this.defaultImage = defaultImage;
        this.resourceType = resourceType;
    }

    @Override
    public boolean shouldDownloadImage(ModpackModel imageKey) {
        Resource res = this.resourceType.getResource(imageKey);
        if (res == null) {
            return false;
        }
        String md5 = res.getMd5();
        if (md5 == null || md5.isEmpty()) {
            return true;
        }
        return !CryptoUtils.checkMD5(this.getImageLocation(imageKey), md5);
    }

    @Override
    public File getImageLocation(ModpackModel imageKey) {
        return this.fileSystem.getPackAssetsDirectory().resolve(imageKey.getName()).resolve(this.resourceType.getImageName()).toFile();
    }

    @Override
    public BufferedImage getDefaultImage() {
        return this.defaultImage;
    }
}

