/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.modpacks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import net.technicpack.launcher.io.InstalledPackStore;
import net.technicpack.launcher.io.LauncherFileSystem;
import net.technicpack.launchercore.modpacks.IModpackContainer;
import net.technicpack.launchercore.modpacks.InstalledPack;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.launchercore.modpacks.sources.IAuthoritativePackSource;
import net.technicpack.launchercore.modpacks.sources.IModpackTagBuilder;
import net.technicpack.launchercore.modpacks.sources.IPackSource;
import net.technicpack.rest.io.PackInfo;

public class PackLoadJob
implements Runnable {
    private LauncherFileSystem fileSystem;
    private IModpackTagBuilder tagBuilder;
    private IAuthoritativePackSource authoritativeSource;
    private InstalledPackStore packStore;
    private Collection<IPackSource> packSources;
    private IModpackContainer container;
    private boolean doLoadRepository;
    private Map<String, ModpackModel> processedModpacks = new HashMap<String, ModpackModel>();
    private boolean isCancelled = false;

    public PackLoadJob(LauncherFileSystem fileSystem, InstalledPackStore packStore, IAuthoritativePackSource authoritativeSource, Collection<IPackSource> packSources, IModpackContainer container, IModpackTagBuilder tagBuilder, boolean doLoadRepository) {
        this.packStore = packStore;
        this.authoritativeSource = authoritativeSource;
        this.packSources = packSources;
        this.container = container;
        this.tagBuilder = tagBuilder;
        this.fileSystem = fileSystem;
        this.doLoadRepository = doLoadRepository;
        container.clear();
    }

    public void cancel() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.isCancelled = true;
        } else {
            SwingUtilities.invokeLater(this::cancel);
        }
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void run() {
        int threadCount = 0;
        if (this.doLoadRepository) {
            ++threadCount;
        }
        if (this.packSources != null) {
            threadCount += this.packSources.size();
        }
        ArrayList<1> threads = new ArrayList<1>(threadCount);
        if (this.doLoadRepository) {
            for (String string : this.packStore.getPackNames()) {
                InstalledPack pack = this.packStore.getInstalledPacks().get(string);
                this.addPackThreadSafe(pack, null, -1);
            }
        }
        if (this.packSources != null) {
            for (final IPackSource iPackSource : this.packSources) {
                Thread packSourceThread = new Thread(iPackSource.getSourceName() + " Loading Thread"){

                    @Override
                    public void run() {
                        for (PackInfo info : iPackSource.getPublicPacks()) {
                            PackLoadJob.this.addPackThreadSafe(null, info, iPackSource.getPriority(info));
                        }
                    }
                };
                threads.add(packSourceThread);
                packSourceThread.start();
            }
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.refreshCompleteThreadSafe();
    }

    protected void refreshCompleteThreadSafe() {
        SwingUtilities.invokeLater(() -> this.container.refreshComplete());
    }

    protected void addPackThreadSafe(InstalledPack pack, PackInfo packInfo, int priority) {
        SwingUtilities.invokeLater(() -> this.addPack(pack, packInfo, priority));
    }

    protected void addPack(InstalledPack pack, PackInfo packInfo, int priority) {
        ModpackModel modpack;
        if (pack == null && packInfo == null || this.isCancelled) {
            return;
        }
        String name = pack != null ? pack.getName() : packInfo.getName();
        boolean newModpackModel = true;
        if (this.processedModpacks.containsKey(name)) {
            modpack = this.processedModpacks.get(name);
            newModpackModel = false;
            if (modpack.getInstalledPack() == null && pack != null) {
                modpack.setInstalledPack(pack, this.packStore);
            }
            if (packInfo != null) {
                modpack.setPackInfo(packInfo);
                modpack.updatePriority(priority);
            }
        } else {
            modpack = new ModpackModel(pack, packInfo, this.packStore, this.fileSystem);
            modpack.updatePriority(priority);
            if (packInfo == null) {
                modpack.setIsPlatform(false);
            }
            this.processedModpacks.put(name, modpack);
        }
        if (modpack.getInstalledPack() == null && !this.doLoadRepository && this.packStore.getInstalledPacks().containsKey(modpack.getName())) {
            modpack.setInstalledPack(this.packStore.getInstalledPacks().get(modpack.getName()), this.packStore);
        }
        Runnable fillDataMethod = null;
        if (modpack.getPackInfo() == null) {
            fillDataMethod = () -> {
                PackInfo completeInfo = this.authoritativeSource.getPackInfo(pack);
                if (completeInfo != null) {
                    this.addPackThreadSafe(null, completeInfo, priority);
                }
            };
        } else if (!modpack.getPackInfo().isComplete()) {
            fillDataMethod = () -> {
                PackInfo completeInfo = this.authoritativeSource.getCompletePackInfo(packInfo);
                if (completeInfo != null) {
                    this.addPackThreadSafe(null, completeInfo, priority);
                }
            };
        }
        if (fillDataMethod != null) {
            Thread thread = new Thread(fillDataMethod);
            thread.start();
        }
        if (modpack != null && this.tagBuilder != null) {
            modpack.updateTags(this.tagBuilder);
        }
        if (newModpackModel) {
            this.container.addModpackToContainer(modpack);
        } else {
            this.container.replaceModpackInContainer(modpack);
        }
    }
}

