/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.mirror.download;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.OverlappingFileLockException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.technicpack.launchercore.exception.DownloadException;
import net.technicpack.launchercore.exception.PermissionDeniedException;
import net.technicpack.launchercore.mirror.download.CountingReadableByteChannel;
import net.technicpack.launchercore.util.DownloadListener;
import net.technicpack.utilslib.Utils;

public class Download
implements Runnable {
    private static final long TIMEOUT = 30000L;
    private URL url;
    private long size = -1L;
    private long downloaded = 0L;
    private String outPath;
    private String name;
    private DownloadListener listener;
    private Result result = Result.FAILURE;
    private File outFile = null;
    private Exception exception = null;
    private final Object timeoutLock = new Object();
    private final Object progressLock = new Object();
    private boolean isTimedOut = false;

    public Download(URL url, String name, String outPath) {
        this.url = url;
        this.outPath = outPath;
        this.name = name;
    }

    public float getProgress() {
        if (this.size > 0L) {
            return (float)((double)this.downloaded / (double)this.size * 100.0);
        }
        return 0.0f;
    }

    public Exception getException() {
        return this.exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            String redirUrlText;
            HttpURLConnection conn = Utils.openHttpConnection(this.url);
            int response = conn.getResponseCode();
            int responseFamily = response / 100;
            if (responseFamily == 3 && (redirUrlText = conn.getHeaderField("Location")) != null && !redirUrlText.isEmpty()) {
                URL redirectUrl;
                try {
                    redirectUrl = new URL(redirUrlText);
                }
                catch (MalformedURLException e) {
                    throw new DownloadException("Invalid Redirect URL: " + this.url, e);
                }
                conn = Utils.openHttpConnection(redirectUrl);
                response = conn.getResponseCode();
                responseFamily = response / 100;
            }
            if (response == 429) {
                throw new DownloadException("The download is being rate limited (HTTP 429). Try again later.");
            }
            if (response == 404) {
                throw new DownloadException("The specified URL does not exist (HTTP 404).");
            }
            if (responseFamily != 2) {
                throw new DownloadException("The server issued a " + response + " response code.");
            }
            InputStream in = this.getConnectionInputStream(conn);
            this.size = conn.getContentLengthLong();
            this.outFile = new File(this.outPath);
            this.outFile.delete();
            long startTime = System.nanoTime();
            try (CountingReadableByteChannel rbc = new CountingReadableByteChannel(Channels.newChannel(in));
                 FileOutputStream fos = new FileOutputStream(this.outFile);){
                fos.getChannel().lock();
                this.stateChanged();
                MonitorThread progress = new MonitorThread(rbc);
                progress.start();
                fos.getChannel().transferFrom(rbc, 0L, this.size > 0L ? this.size : Long.MAX_VALUE);
                in.close();
                rbc.close();
                progress.interrupt();
                Object object = this.timeoutLock;
                // MONITORENTER : object
                if (this.isTimedOut) {
                    // MONITOREXIT : object
                    return;
                }
                // MONITOREXIT : object
                if (this.size > 0L) {
                    long fileLength = this.outFile.length();
                    if (this.size != fileLength) throw new DownloadException("File size doesn't match. Expected " + this.size + ", got " + fileLength);
                    this.result = Result.SUCCESS;
                } else {
                    this.result = Result.SUCCESS;
                }
            }
            long endTime = System.nanoTime();
            long durationNs = endTime - startTime;
            double durationSeconds = (double)durationNs / 1.0E9;
            long fileLength = this.outFile.length();
            Utils.getLogger().fine(String.format("Download completed: %d bytes in %.3f seconds (%.2f MB/s)", fileLength, durationSeconds, (double)fileLength / durationSeconds / 1048576.0));
            return;
        }
        catch (ClosedByInterruptException e) {
            this.result = Result.FAILURE;
            return;
        }
        catch (PermissionDeniedException e) {
            this.exception = e;
            this.result = Result.PERMISSION_DENIED;
            return;
        }
        catch (OverlappingFileLockException e) {
            this.exception = e;
            this.result = Result.LOCK_FAILED;
            return;
        }
        catch (DownloadException e) {
            this.exception = e;
            this.result = Result.FAILURE;
            return;
        }
        catch (Exception e) {
            this.exception = e;
            e.printStackTrace();
        }
    }

    protected InputStream getConnectionInputStream(URLConnection urlconnection) throws DownloadException {
        AtomicReference<InputStream> is = new AtomicReference<InputStream>();
        for (int j = 0; j < 3 && is.get() == null; ++j) {
            StreamThread stream = new StreamThread(urlconnection, is);
            stream.start();
            int iterationCount = 0;
            while (is.get() == null && iterationCount++ < 5) {
                try {
                    stream.join(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (stream.permDenied.get()) {
                throw new PermissionDeniedException("Permission denied!");
            }
            if (is.get() != null) break;
            try {
                stream.interrupt();
                stream.join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (is.get() == null) {
            throw new DownloadException("Unable to download file from " + urlconnection.getURL());
        }
        return new BufferedInputStream((InputStream)is.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stateChanged() {
        if (this.listener != null) {
            this.listener.stateChanged(this.name, this.getProgress());
        }
        Object object = this.progressLock;
        synchronized (object) {
            this.progressLock.notifyAll();
        }
    }

    public void setListener(DownloadListener listener) {
        this.listener = listener;
    }

    public Result getResult() {
        return this.result;
    }

    public File getOutFile() {
        return this.outFile;
    }

    public static enum Result {
        SUCCESS,
        FAILURE,
        PERMISSION_DENIED,
        LOCK_FAILED;

    }

    private class MonitorThread
    extends Thread {
        private final CountingReadableByteChannel rbc;
        private long last;

        public MonitorThread(CountingReadableByteChannel rbc) {
            super("Download Monitor Thread");
            this.last = System.currentTimeMillis();
            this.setDaemon(true);
            this.rbc = rbc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isInterrupted()) {
                long bytesRead = this.rbc.getBytesRead();
                long bytesDelta = bytesRead - Download.this.downloaded;
                Download.this.downloaded = bytesRead;
                if (bytesDelta == 0L) {
                    if (System.currentTimeMillis() - this.last > 30000L) {
                        try {
                            this.rbc.close();
                        }
                        catch (IOException | NullPointerException exception) {
                            // empty catch block
                        }
                        this.timeout();
                        return;
                    }
                } else {
                    this.last = System.currentTimeMillis();
                }
                Download.this.stateChanged();
                Object object = Download.this.progressLock;
                synchronized (object) {
                    try {
                        Download.this.progressLock.wait(33L);
                    }
                    catch (InterruptedException e) {
                        this.interrupt();
                        return;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void timeout() {
            Object object = Download.this.timeoutLock;
            synchronized (object) {
                Download.this.isTimedOut = true;
            }
        }
    }

    private static class StreamThread
    extends Thread {
        private final URLConnection urlconnection;
        private final AtomicReference<InputStream> is;
        public final AtomicBoolean permDenied = new AtomicBoolean(false);

        public StreamThread(URLConnection urlconnection, AtomicReference<InputStream> is) {
            this.urlconnection = urlconnection;
            this.is = is;
        }

        @Override
        public void run() {
            try {
                this.is.set(this.urlconnection.getInputStream());
            }
            catch (SocketException e) {
                if (e.getMessage().equalsIgnoreCase("Permission denied: connect")) {
                    this.permDenied.set(true);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

