/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.mirror.download;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class CountingReadableByteChannel
implements ReadableByteChannel {
    private final ReadableByteChannel wrapped;
    private long bytesRead = 0L;

    public CountingReadableByteChannel(ReadableByteChannel wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int n = this.wrapped.read(dst);
        if (n > 0) {
            this.bytesRead += (long)n;
        }
        return n;
    }

    @Override
    public boolean isOpen() {
        return this.wrapped.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.wrapped.close();
    }

    public long getBytesRead() {
        return this.bytesRead;
    }
}

