/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class RotatingFileHandler
extends StreamHandler {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private Path logsDirectory;
    private final String filenameFormat;
    private String currentFilename;

    public RotatingFileHandler(Path logsDirectory, String filenameFormat) {
        this.filenameFormat = filenameFormat;
        this.setLogsDirectory(logsDirectory);
    }

    private synchronized void setLogsDirectory(Path logsDirectory) {
        if (logsDirectory == null) {
            throw new NullPointerException("logsDirectory cannot be null");
        }
        this.logsDirectory = logsDirectory;
        this.updateOutputFile();
    }

    private synchronized void updateOutputFile() {
        this.currentFilename = this.buildFilename();
        try {
            OutputStream out = Files.newOutputStream(this.logsDirectory.resolve(this.currentFilename), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            this.setOutputStream(out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String buildFilename() {
        return String.format(this.filenameFormat, this.dateFormat.format(new Date()));
    }

    private synchronized void changeFileIfNeeded() {
        String newFilename = this.buildFilename();
        if (!this.currentFilename.equals(newFilename)) {
            String oldPath = this.currentFilename;
            this.currentFilename = newFilename;
            this.updateOutputFile();
            super.publish(new LogRecord(Level.INFO, String.format("Continued from %s", oldPath)));
        }
    }

    @Override
    public synchronized void publish(LogRecord record) {
        this.changeFileIfNeeded();
        super.publish(record);
        this.flush();
    }
}

