/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.launch.java.version;

import java.io.File;
import java.util.Objects;
import net.technicpack.launchercore.launch.java.IJavaRuntime;
import net.technicpack.utilslib.OperatingSystem;

public final class CurrentJavaRuntime
implements IJavaRuntime {
    private final String version = System.getProperty("java.version");
    private final String vendor = System.getProperty("java.vendor");
    private final boolean is64Bit;
    private final String osArch = System.getProperty("os.arch");
    private final File executableFile;

    public CurrentJavaRuntime() {
        this.is64Bit = this.osArch.contains("64");
        this.executableFile = new File(OperatingSystem.getJavaDir()).getAbsoluteFile();
    }

    @Override
    public File getExecutableFile() {
        return this.executableFile;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    @Override
    public String getOsArch() {
        return this.osArch;
    }

    @Override
    public String getBitness() {
        return this.is64Bit ? "64" : "32";
    }

    @Override
    public boolean is64Bit() {
        return this.is64Bit;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CurrentJavaRuntime that = (CurrentJavaRuntime)o;
        return this.is64Bit == that.is64Bit && Objects.equals(this.version, that.version) && Objects.equals(this.vendor, that.vendor) && Objects.equals(this.osArch, that.osArch);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.vendor, this.is64Bit, this.osArch);
    }

    public String toString() {
        return "CurrentJavaRuntime{version='" + this.version + '\'' + ", vendor='" + this.vendor + '\'' + ", is64Bit=" + this.is64Bit + ", osArch='" + this.osArch + '\'' + ", executableFile=" + this.executableFile + '}';
    }
}

