/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.install.verifiers;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.zip.ZipFile;
import net.technicpack.launchercore.install.verifiers.IFileVerifier;
import net.technicpack.utilslib.Utils;

public class ValidZipFileVerifier
implements IFileVerifier {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isFileValid(File file) {
        try (ZipFile ignored = new ZipFile(file);){
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Utils.getLogger().log(Level.WARNING, String.format("ZIP validation failed for %s", file.getAbsolutePath()), e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isFileValid(Path path) {
        try (ZipFile ignored = new ZipFile(path.toFile());){
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Utils.getLogger().log(Level.WARNING, String.format("ZIP validation failed for %s", path), e);
            return false;
        }
    }
}

