/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.install.verifiers;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.logging.Level;
import net.technicpack.launchercore.install.verifiers.IFileVerifier;
import net.technicpack.utilslib.Utils;

public class ValidJsonFileVerifier
implements IFileVerifier {
    private Gson validatingGson;

    public ValidJsonFileVerifier(Gson validatingGson) {
        this.validatingGson = validatingGson;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isFileValid(File file) {
        try (BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
            JsonObject obj = this.validatingGson.fromJson((Reader)reader, JsonObject.class);
            boolean bl = obj != null;
            return bl;
        }
        catch (JsonIOException | IOException e) {
            Utils.getLogger().log(Level.SEVERE, String.format("An I/O error happened while validating %s", file.getAbsolutePath()), e);
            return false;
        }
        catch (JsonParseException e) {
            Utils.getLogger().log(Level.WARNING, String.format("JSON validation failed for %s", file.getAbsolutePath()), e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isFileValid(Path path) {
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            JsonObject obj = this.validatingGson.fromJson((Reader)reader, JsonObject.class);
            boolean bl = obj != null;
            return bl;
        }
        catch (JsonIOException | IOException e) {
            Utils.getLogger().log(Level.SEVERE, String.format("An I/O error happened while validating %s", path), e);
            return false;
        }
        catch (JsonParseException e) {
            Utils.getLogger().log(Level.WARNING, String.format("JSON validation failed for %s", path), e);
            return false;
        }
    }
}

