/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.install.verifiers;

import java.io.File;
import java.nio.file.Path;
import net.technicpack.launchercore.install.verifiers.IFileVerifier;
import net.technicpack.utilslib.CryptoUtils;
import net.technicpack.utilslib.Utils;

public class SHA256FileVerifier
implements IFileVerifier {
    private String expectedHash;

    public SHA256FileVerifier(String expectedHash) {
        this.expectedHash = expectedHash;
    }

    @Override
    public boolean isFileValid(File file) {
        if (this.expectedHash == null || this.expectedHash.isEmpty()) {
            return false;
        }
        String resultSha256 = CryptoUtils.getSHA256(file);
        boolean hashMatches = this.expectedHash.equalsIgnoreCase(resultSha256);
        if (!hashMatches) {
            Utils.getLogger().warning("SHA256 verification for " + file + " failed. Expected " + this.expectedHash + ", got " + resultSha256);
        }
        return hashMatches;
    }

    @Override
    public boolean isFileValid(Path path) {
        if (this.expectedHash == null || this.expectedHash.isEmpty()) {
            return false;
        }
        String resultSha256 = CryptoUtils.getSHA256(path);
        boolean hashMatches = this.expectedHash.equalsIgnoreCase(resultSha256);
        if (!hashMatches) {
            Utils.getLogger().warning("SHA256 verification for " + path + " failed. Expected " + this.expectedHash + ", got " + resultSha256);
        }
        return hashMatches;
    }
}

