/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.install.verifiers;

import java.io.File;
import java.nio.file.Path;
import net.technicpack.launchercore.install.verifiers.IFileVerifier;
import net.technicpack.utilslib.CryptoUtils;
import net.technicpack.utilslib.Utils;

public class MD5FileVerifier
implements IFileVerifier {
    private final String expectedHash;

    public MD5FileVerifier(String expectedHash) {
        this.expectedHash = expectedHash;
    }

    @Override
    public boolean isFileValid(File file) {
        if (this.expectedHash == null || this.expectedHash.isEmpty()) {
            return false;
        }
        String resultMD5 = CryptoUtils.getMD5(file);
        boolean hashMatches = this.expectedHash.equalsIgnoreCase(resultMD5);
        if (!hashMatches) {
            Utils.getLogger().warning("MD5 verification for " + file + " failed. Expected " + this.expectedHash + ", got " + resultMD5);
        }
        return hashMatches;
    }

    @Override
    public boolean isFileValid(Path path) {
        if (this.expectedHash == null || this.expectedHash.isEmpty()) {
            return false;
        }
        String resultMD5 = CryptoUtils.getMD5(path);
        boolean hashMatches = this.expectedHash.equalsIgnoreCase(resultMD5);
        if (!hashMatches) {
            Utils.getLogger().warning("MD5 verification for " + path + " failed. Expected " + this.expectedHash + ", got " + resultMD5);
        }
        return hashMatches;
    }
}

