/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.install.verifiers;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.logging.Level;
import net.technicpack.launchercore.install.verifiers.IFileVerifier;
import net.technicpack.utilslib.Utils;

public class FileSizeVerifier
implements IFileVerifier {
    private final long size;

    public FileSizeVerifier(long size) {
        this.size = size;
    }

    @Override
    public boolean isFileValid(File file) {
        return file.length() == this.size;
    }

    @Override
    public boolean isFileValid(Path path) {
        try {
            return Files.size(path) == this.size;
        }
        catch (IOException e) {
            Utils.getLogger().log(Level.WARNING, String.format("File size verification failed for %s", path.toAbsolutePath()), e);
            return false;
        }
    }
}

