/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.install.tasks;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.tasks.IInstallTask;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.minecraftcore.mojang.version.IMinecraftVersionInfo;
import net.technicpack.rest.io.Modpack;
import net.technicpack.utilslib.Utils;

public class WriteRundataFile
implements IInstallTask<IMinecraftVersionInfo> {
    private ModpackModel modpackModel;
    private Modpack modpack;

    public WriteRundataFile(ModpackModel modpackModel, Modpack modpack) {
        this.modpackModel = modpackModel;
        this.modpack = modpack;
    }

    @Override
    public String getTaskDescription() {
        return "Writing Runtime Data";
    }

    @Override
    public float getTaskProgress() {
        return 0.0f;
    }

    @Override
    public void runTask(InstallTasksQueue<IMinecraftVersionInfo> queue) throws IOException {
        if ((this.modpack.getJava() == null || this.modpack.getJava().isEmpty()) && (this.modpack.getMemory() == null || this.modpack.getMemory().isEmpty())) {
            return;
        }
        File file = this.modpackModel.getBinDir();
        File runDataFile = new File(file, "runData");
        JsonObject runData = new JsonObject();
        JsonElement java = this.getJsonValue(this.modpack.getJava());
        JsonElement memory = this.getJsonValue(this.modpack.getMemory());
        runData.add("java", java);
        runData.add("memory", memory);
        try (BufferedWriter writer = Files.newBufferedWriter(runDataFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            Utils.getGson().toJson((JsonElement)runData, (Appendable)writer);
        }
        catch (JsonIOException e) {
            throw new IOException(String.format("Error writing runData file %s", runDataFile), e);
        }
    }

    private JsonElement getJsonValue(String value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive(value);
    }
}

