/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.install.tasks;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.tasks.IInstallTask;

public class EnsureLinkedFileTask<T>
implements IInstallTask<T> {
    private Path link;
    private Path target;

    public EnsureLinkedFileTask(Path link, Path target) {
        this.link = link;
        this.target = target;
    }

    @Override
    public String getTaskDescription() {
        return "Linking files.";
    }

    @Override
    public float getTaskProgress() {
        return 0.0f;
    }

    @Override
    public void runTask(InstallTasksQueue<T> queue) throws IOException {
        if (Files.isSymbolicLink(this.link) && Files.readSymbolicLink(this.link).equals(this.target)) {
            return;
        }
        Files.deleteIfExists(this.link);
        Files.createSymbolicLink(this.link, this.target, new FileAttribute[0]);
    }
}

