/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.install.tasks;

import java.io.File;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.tasks.IInstallTask;
import net.technicpack.launchercore.install.tasks.TaskGroup;
import net.technicpack.launchercore.install.tasks.WriteRundataFile;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.minecraftcore.mojang.version.IMinecraftVersionInfo;
import net.technicpack.rest.io.Modpack;

public class CheckRunDataFile
implements IInstallTask<IMinecraftVersionInfo> {
    private final ModpackModel modpackModel;
    private final Modpack modpack;
    private final TaskGroup<IMinecraftVersionInfo> writeRunDataGroup;

    public CheckRunDataFile(ModpackModel modpackModel, Modpack modpack, TaskGroup<IMinecraftVersionInfo> writeRunDataGroup) {
        this.modpackModel = modpackModel;
        this.modpack = modpack;
        this.writeRunDataGroup = writeRunDataGroup;
    }

    @Override
    public String getTaskDescription() {
        return "Checking Runtime Data...";
    }

    @Override
    public float getTaskProgress() {
        return 0.0f;
    }

    @Override
    public void runTask(InstallTasksQueue<IMinecraftVersionInfo> queue) {
        File file = this.modpackModel.getBinDir();
        File runDataFile = new File(file, "runData");
        if (runDataFile.exists()) {
            return;
        }
        if (this.modpackModel.isLocalOnly()) {
            return;
        }
        this.writeRunDataGroup.addTask(new WriteRundataFile(this.modpackModel, this.modpack));
    }
}

