/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.install;

import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.logging.Level;
import net.technicpack.utilslib.Utils;

public class ModpackVersion {
    private String version;
    private boolean legacy;

    private ModpackVersion() {
    }

    public ModpackVersion(String version, boolean legacy) {
        this.version = version;
        this.legacy = legacy;
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    public String getVersion() {
        return this.version;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ModpackVersion load(File versionFile) {
        if (!versionFile.exists()) {
            Utils.getLogger().log(Level.WARNING, String.format("Unable to load version from %s because it does not exist.", versionFile));
            return null;
        }
        try (BufferedReader reader = Files.newBufferedReader(versionFile.toPath(), StandardCharsets.UTF_8);){
            ModpackVersion modpackVersion = Utils.getGson().fromJson((Reader)reader, ModpackVersion.class);
            return modpackVersion;
        }
        catch (JsonParseException | IOException e) {
            Utils.getLogger().log(Level.WARNING, String.format("Unable to load version from %s", versionFile), e);
            return null;
        }
    }

    public void save(File versionFile) {
        try (BufferedWriter writer = Files.newBufferedWriter(versionFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            Utils.getGson().toJson((Object)this, (Appendable)writer);
        }
        catch (JsonIOException | IOException e) {
            Utils.getLogger().log(Level.WARNING, String.format("Unable to save installed %s", versionFile), e);
        }
    }

    public String toString() {
        return String.format("ModpackVersion{version='%s', legacy=%s}", this.version, this.legacy);
    }
}

