/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.install;

import java.io.File;
import java.io.IOException;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.ModpackVersion;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.minecraftcore.mojang.version.IMinecraftVersionInfo;
import net.technicpack.platform.IPlatformApi;
import net.technicpack.utilslib.Utils;

public class ModpackInstaller {
    private final IPlatformApi platformApi;
    private final String clientId;

    public ModpackInstaller(IPlatformApi platformApi, String clientId) {
        this.clientId = clientId;
        this.platformApi = platformApi;
    }

    public IMinecraftVersionInfo installPack(InstallTasksQueue<IMinecraftVersionInfo> tasksQueue, ModpackModel modpack, String build) throws IOException, InterruptedException {
        modpack.save();
        modpack.initDirectories();
        ModpackVersion installedVersion = modpack.getInstalledVersion();
        tasksQueue.runAllTasks();
        ModpackVersion versionFile = new ModpackVersion(build, false);
        versionFile.save(new File(modpack.getBinDir(), "version"));
        if (installedVersion == null) {
            this.platformApi.incrementPackInstalls(modpack.getName());
            Utils.sendTracking("installModpack", modpack.getName(), modpack.getBuild(), this.clientId);
        }
        return tasksQueue.getMetadata();
    }
}

