/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launchercore.image;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import net.technicpack.launchercore.image.IImageJobListener;
import net.technicpack.launchercore.image.IImageMapper;
import net.technicpack.launchercore.image.IImageStore;

public class ImageJob<T> {
    protected IImageMapper<T> mapper;
    protected IImageStore<T> store;
    private T lastJobData;
    protected boolean canRetry = true;
    private final AtomicReference<BufferedImage> imageReference;
    private final Collection<IImageJobListener<T>> jobListeners = new LinkedList<IImageJobListener<T>>();
    private Thread imageThread;

    public ImageJob(IImageMapper<T> mapper, IImageStore<T> store) {
        this.mapper = mapper;
        this.store = store;
        this.imageReference = new AtomicReference();
        this.imageReference.set(mapper.getDefaultImage());
    }

    public BufferedImage getImage() {
        return this.imageReference.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJobListener(IImageJobListener<T> listener) {
        Collection<IImageJobListener<T>> collection = this.jobListeners;
        synchronized (collection) {
            this.jobListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJobListener(IImageJobListener<T> listener) {
        Collection<IImageJobListener<T>> collection = this.jobListeners;
        synchronized (collection) {
            this.jobListeners.remove(listener);
        }
    }

    public boolean canRetry() {
        return this.canRetry;
    }

    public void refreshRetry() {
        this.canRetry = true;
    }

    public T getJobData() {
        return this.lastJobData;
    }

    protected void setImage(BufferedImage image) {
        this.canRetry = false;
        this.imageReference.set(image);
        this.notifyComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyComplete() {
        if (SwingUtilities.isEventDispatchThread()) {
            Collection<IImageJobListener<T>> collection = this.jobListeners;
            synchronized (collection) {
                for (IImageJobListener<T> listener : this.jobListeners) {
                    listener.jobComplete(this);
                }
            }
        } else {
            SwingUtilities.invokeLater(this::notifyComplete);
        }
    }

    public void start(final T jobData) {
        this.lastJobData = jobData;
        if (this.imageThread != null && this.imageThread.isAlive()) {
            return;
        }
        this.imageThread = new Thread("Image Download: " + this.store.getJobKey(jobData)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block12: {
                    try {
                        File imageLocation = ImageJob.this.mapper.getImageLocation(jobData);
                        BufferedImage existingImage = null;
                        if (imageLocation != null && imageLocation.exists()) {
                            try {
                                existingImage = ImageIO.read(imageLocation);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (existingImage != null) {
                            ImageJob.this.setImage(existingImage);
                        }
                        if (!ImageJob.this.store.canDownloadImage(jobData, imageLocation) || existingImage != null && !ImageJob.this.mapper.shouldDownloadImage(jobData)) break block12;
                        if (imageLocation != null && !imageLocation.getParentFile().exists()) {
                            imageLocation.getParentFile().mkdirs();
                        }
                        ImageJob.this.store.downloadImage(jobData, imageLocation);
                        try {
                            BufferedImage newImage = ImageIO.read(imageLocation);
                            if (newImage != null) {
                                ImageJob.this.setImage(newImage);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    finally {
                        if (ImageJob.this.canRetry) {
                            ImageJob.this.canRetry = ImageJob.this.store.canRetry(jobData);
                        }
                    }
                }
            }
        };
        this.imageThread.start();
    }
}

