/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.ui.controls.feeds;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import net.technicpack.launcher.ui.UIConstants;
import net.technicpack.launcher.ui.components.news.AuthorshipWidget;
import net.technicpack.launchercore.image.ImageJob;
import net.technicpack.platform.io.AuthorshipInfo;
import net.technicpack.platform.io.FeedItem;
import net.technicpack.ui.lang.ResourceLoader;

public class FeedItemView
extends JButton {
    private FeedItem feedItem;

    public FeedItemView(ResourceLoader loader, FeedItem feedItem, ImageJob<AuthorshipInfo> avatar) {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setContentAreaFilled(false);
        this.setFocusable(false);
        this.setBackground(UIConstants.COLOR_FEED_ITEM_BACK);
        this.setForeground(UIConstants.COLOR_HEADER_TEXT);
        this.setFont(loader.getFont("OpenSans+Cyberbit.ttf", 12.0f));
        this.feedItem = feedItem;
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        AuthorshipWidget authorship = new AuthorshipWidget(loader, feedItem.getAuthorship(), avatar);
        this.add((Component)authorship, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        authorship.setBounds(0, 0, this.getWidth(), this.getHeight());
        this.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public String getUrl() {
        return this.feedItem.getUrl();
    }

    private Dimension getCalcSize() {
        return new Dimension(250, 132);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getCalcSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getCalcSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getCalcSize();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2d.setColor(this.getBackground());
        g2d.fillRoundRect(0, 0, 250, 94, 15, 15);
        Shape oldClip = g2d.getClip();
        g2d.clipRect(3, 2, 245, 90);
        g2d.setFont(this.getFont());
        g2d.setColor(this.getForeground());
        this.drawTextUgly(this.feedItem.getContent(), g2d, 92);
        g2d.setClip(oldClip);
    }

    private void drawTextUgly(String text, Graphics2D g2, int maxY) {
        int nextStartY;
        String textToDraw = text;
        String[] arr = textToDraw.split(" ");
        int nIndex = 0;
        int startX = 4;
        int startY = 3;
        int lineSize = g2.getFontMetrics().getHeight();
        int elipsisSize = g2.getFontMetrics().stringWidth("...");
        while (nIndex < arr.length && (nextStartY = startY + lineSize) <= maxY) {
            int nextEndY = nextStartY + lineSize;
            StringBuilder line = new StringBuilder(arr[nIndex++]);
            int lineWidth = g2.getFontMetrics().stringWidth(line.toString());
            while (nIndex < arr.length && lineWidth < 243) {
                line.append(' ').append(arr[nIndex]);
                if (++nIndex == arr.length) break;
                lineWidth = g2.getFontMetrics().stringWidth(String.format("%s %s", line, arr[nIndex]));
                if (nextEndY < maxY) continue;
                lineWidth += elipsisSize;
            }
            if (nextEndY >= maxY && nIndex < arr.length) {
                line.append("...");
            }
            g2.drawString(line.toString(), startX, startY + g2.getFontMetrics().getAscent());
            startY = nextStartY;
        }
    }
}

