/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.ui.components.news;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.technicpack.launcher.settings.TechnicSettings;
import net.technicpack.launcher.ui.UIConstants;
import net.technicpack.launcher.ui.components.news.NewsInfoPanel;
import net.technicpack.launcher.ui.controls.feeds.NewsWidget;
import net.technicpack.launchercore.image.ImageRepository;
import net.technicpack.platform.IPlatformApi;
import net.technicpack.platform.io.AuthorshipInfo;
import net.technicpack.platform.io.NewsData;
import net.technicpack.rest.RestfulAPIException;
import net.technicpack.ui.controls.feeds.CountCircle;
import net.technicpack.ui.controls.list.SimpleScrollbarUI;
import net.technicpack.ui.lang.ResourceLoader;
import net.technicpack.utilslib.Utils;

public class NewsSelector
extends JPanel {
    private ResourceLoader resources;
    private IPlatformApi platformApi;
    private NewsWidget selectedItem;
    private JPanel widgetHost;
    private CountCircle circle;
    private TechnicSettings settings;
    private int newLatestNewsArticle;
    private NewsInfoPanel panel;
    private ImageRepository<AuthorshipInfo> avatarRepo;

    public NewsSelector(ResourceLoader resources, NewsInfoPanel panel, IPlatformApi platformApi, ImageRepository<AuthorshipInfo> avatarRepo, CountCircle count, TechnicSettings settings) {
        this.resources = resources;
        this.platformApi = platformApi;
        this.avatarRepo = avatarRepo;
        this.panel = panel;
        this.settings = settings;
        this.circle = count;
        this.initComponents();
        this.downloadItems();
    }

    protected void selectNewsItem(NewsWidget widget) {
        if (this.selectedItem != null) {
            this.selectedItem.setIsSelected(false);
        }
        this.selectedItem = widget;
        if (this.selectedItem != null) {
            this.selectedItem.setIsSelected(true);
        }
        this.panel.setArticle(this.selectedItem.getArticle());
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBackground(UIConstants.COLOR_SELECTOR_BACK);
        this.widgetHost = new JPanel();
        this.widgetHost.setOpaque(false);
        this.widgetHost.setLayout(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane(this.widgetHost, 20, 31);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.getVerticalScrollBar().setUI(new SimpleScrollbarUI(UIConstants.COLOR_SCROLL_TRACK, UIConstants.COLOR_SCROLL_THUMB));
        scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(10, 10));
        scrollPane.getVerticalScrollBar().setUnitIncrement(12);
        this.add((Component)scrollPane, "Center");
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0);
        constraints.weighty = 1.0;
        this.widgetHost.add(Box.createGlue(), constraints);
    }

    public void ping() {
        this.settings.setLatestNewsArticle(this.newLatestNewsArticle);
        this.circle.setVisible(false);
    }

    protected void loadNewsItems(NewsData news) {
        int count = 0;
        this.newLatestNewsArticle = this.settings.getLatestNewsArticle();
        for (int i = 0; i < news.getArticles().size(); ++i) {
            if (news.getArticles().get(i).getId() <= this.settings.getLatestNewsArticle()) continue;
            ++count;
            if (news.getArticles().get(i).getId() <= this.newLatestNewsArticle) continue;
            this.newLatestNewsArticle = news.getArticles().get(i).getId();
        }
        if (count > 0) {
            this.circle.setVisible(true);
            this.circle.setCount(count);
        } else {
            this.circle.setVisible(false);
        }
        news.getArticles().sort((o1, o2) -> Long.compare(o2.getDate().getTime(), o1.getDate().getTime()));
        this.widgetHost.removeAll();
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0);
        for (int i = 0; i < news.getArticles().size(); ++i) {
            NewsWidget widget = new NewsWidget(this.resources, news.getArticles().get(i), this.avatarRepo.startImageJob(news.getArticles().get(i).getAuthorshipInfo()));
            widget.addActionListener(e -> {
                if (e.getSource() instanceof NewsWidget) {
                    this.selectNewsItem((NewsWidget)e.getSource());
                }
            });
            this.widgetHost.add((Component)widget, constraints);
            ++constraints.gridy;
            if (this.selectedItem != null) continue;
            this.selectNewsItem(widget);
        }
        constraints.weighty = 1.0;
        this.widgetHost.add(Box.createGlue(), constraints);
    }

    private void downloadItems() {
        Thread thread = new Thread(() -> {
            try {
                this.loadNewsItems(this.platformApi.getNews());
            }
            catch (RestfulAPIException e) {
                Utils.getLogger().log(Level.WARNING, "Unable to load news", e);
            }
        });
        thread.start();
    }
}

