/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.ui.components.news;

import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.technicpack.launcher.ui.UIConstants;
import net.technicpack.launchercore.image.IImageJobListener;
import net.technicpack.launchercore.image.ImageJob;
import net.technicpack.platform.io.AuthorshipInfo;
import net.technicpack.ui.lang.ResourceLoader;
import net.technicpack.utilslib.ImageUtils;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.LocalDate;
import org.joda.time.Minutes;
import org.joda.time.Months;
import org.joda.time.Years;

public class AuthorshipWidget
extends JPanel
implements IImageJobListener<AuthorshipInfo> {
    private JLabel avatarView;
    private ResourceLoader resources;
    private JLabel authorName;
    private JLabel postTime;

    public AuthorshipWidget(ResourceLoader resources) {
        this.resources = resources;
        this.initComponents(resources);
    }

    public AuthorshipWidget(ResourceLoader resources, AuthorshipInfo authorshipInfo, ImageJob<AuthorshipInfo> avatar) {
        this(resources);
        this.setAuthorshipInfo(authorshipInfo, avatar);
    }

    private void initComponents(ResourceLoader resources) {
        this.setLayout(new BoxLayout(this, 2));
        this.setOpaque(false);
        this.avatarView = new JLabel();
        this.add(this.avatarView);
        this.add(Box.createHorizontalStrut(6));
        this.authorName = new JLabel("");
        this.authorName.setFont(resources.getFont("OpenSans+Cyberbit.ttf", 12.0f, 1));
        this.authorName.setForeground(UIConstants.COLOR_WHITE_TEXT);
        this.add(this.authorName);
        this.add(Box.createHorizontalStrut(6));
        this.postTime = new JLabel("");
        this.postTime.setForeground(UIConstants.COLOR_WHITE_TEXT);
        this.postTime.setFont(resources.getFont("OpenSans+Cyberbit.ttf", 12.0f));
        this.add(this.postTime);
        this.add(Box.createHorizontalStrut(4));
    }

    private String getDateText(Date date) {
        LocalDate posted = new LocalDate(date.getTime());
        LocalDate now = new LocalDate();
        Years yearsSince = Years.yearsBetween(posted, now);
        Months monthsSince = Months.monthsBetween(posted, now);
        Days daysSince = Days.daysBetween(posted, now);
        Hours hoursSince = Hours.hoursBetween(posted, now);
        Minutes minutesSince = Minutes.minutesBetween(posted, now);
        if (yearsSince.getYears() > 1) {
            return this.resources.getString("time.years", Integer.toString(yearsSince.getYears()));
        }
        if (yearsSince.getYears() == 1) {
            return this.resources.getString("time.year", new String[0]);
        }
        if (monthsSince.getMonths() > 1) {
            return this.resources.getString("time.months", Integer.toString(monthsSince.getMonths()));
        }
        if (monthsSince.getMonths() == 1) {
            return this.resources.getString("time.month", new String[0]);
        }
        if (daysSince.getDays() > 1) {
            return this.resources.getString("time.days", Integer.toString(daysSince.getDays()));
        }
        if (daysSince.getDays() == 1) {
            return this.resources.getString("time.day", new String[0]);
        }
        if (hoursSince.getHours() > 1) {
            return this.resources.getString("time.hours", Integer.toString(hoursSince.getHours()));
        }
        if (hoursSince.getHours() == 1) {
            return this.resources.getString("time.hour", new String[0]);
        }
        if (minutesSince.getMinutes() > 1) {
            return this.resources.getString("time.minutes", Integer.toString(minutesSince.getMinutes()));
        }
        return this.resources.getString("time.minute", new String[0]);
    }

    @Override
    public void jobComplete(ImageJob<AuthorshipInfo> job) {
        this.updateAvatar(job);
    }

    public void updateAvatar(ImageJob<AuthorshipInfo> job) {
        this.avatarView.setIcon(new ImageIcon(this.resources.getCircleClippedImage(ImageUtils.scaleWithAspectWidth(job.getImage(), 32))));
    }

    public void setAuthorshipInfo(AuthorshipInfo info, ImageJob<AuthorshipInfo> avatar) {
        this.postTime.setText(this.resources.getString("launcher.news.posted", this.getDateText(info.getDate())) + " ");
        this.authorName.setText(info.getUser());
        avatar.addJobListener(this);
        this.updateAvatar(avatar);
    }
}

