/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.ui.components.discover;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Level;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.technicpack.launcher.io.LauncherFileSystem;
import net.technicpack.launcher.ui.components.discover.DiscoverLinkListener;
import net.technicpack.launcher.ui.components.discover.DiscoverResourceLoader;
import net.technicpack.launcher.ui.components.modpacks.ModpackSelector;
import net.technicpack.platform.IPlatformApi;
import net.technicpack.ui.lang.ResourceLoader;
import net.technicpack.utilslib.Utils;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.xhtmlrenderer.event.DocumentListener;
import org.xhtmlrenderer.resource.XMLResource;
import org.xhtmlrenderer.simple.XHTMLPanel;
import org.xhtmlrenderer.swing.DelegatingUserAgent;
import org.xhtmlrenderer.swing.FSMouseListener;
import org.xhtmlrenderer.swing.ImageResourceLoader;
import org.xhtmlrenderer.swing.SwingReplacedElementFactory;

public class DiscoverInfoPanel
extends JPanel {
    private final XHTMLPanel panel;
    private final LauncherFileSystem fileSystem;
    private final ResourceLoader resources;
    private ActionListener loadListener = null;

    public DiscoverInfoPanel(ResourceLoader loader, String discoverUrl, IPlatformApi platform, LauncherFileSystem fileSystem, ModpackSelector modpackSelector) {
        this.fileSystem = fileSystem;
        this.resources = loader;
        if (discoverUrl == null) {
            discoverUrl = "https://api.technicpack.net/discover/";
        }
        final String runnableAccessDiscover = discoverUrl;
        this.setLayout(new BorderLayout());
        this.panel = new XHTMLPanel();
        this.panel.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.panel.setDefaultFontFromComponent(true);
        this.panel.addDocumentListener(new DocumentListener(){
            private boolean hasReloaded = false;

            @Override
            public void documentStarted() {
            }

            @Override
            public void documentLoaded() {
                DiscoverInfoPanel.this.triggerLoadListener();
            }

            @Override
            public void onLayoutException(Throwable throwable) {
                Utils.getLogger().log(Level.SEVERE, "Discover page layout exception", throwable);
                if (!this.hasReloaded) {
                    this.hasReloaded = true;
                    SwingUtilities.invokeLater(() -> DiscoverInfoPanel.this.panel.setDocument(DiscoverInfoPanel.this.getDiscoverDocumentFromResource(), runnableAccessDiscover));
                }
            }

            @Override
            public void onRenderException(Throwable throwable) {
                Utils.getLogger().log(Level.SEVERE, "Discover page render exception", throwable);
                if (!this.hasReloaded) {
                    this.hasReloaded = true;
                    SwingUtilities.invokeLater(() -> DiscoverInfoPanel.this.panel.setDocument(DiscoverInfoPanel.this.getDiscoverDocumentFromResource(), runnableAccessDiscover));
                }
            }
        });
        for (FSMouseListener listener : this.panel.getMouseTrackingListeners()) {
            this.panel.removeMouseTrackingListener(listener);
        }
        this.panel.addMouseTrackingListener(new DiscoverLinkListener(platform, modpackSelector));
        DelegatingUserAgent uac = new DelegatingUserAgent();
        DiscoverResourceLoader imageLoader = new DiscoverResourceLoader();
        ((ImageResourceLoader)imageLoader).setRepaintListener(this.panel);
        ((ImageResourceLoader)imageLoader).clear();
        uac.setImageResourceLoader(imageLoader);
        this.panel.getSharedContext().getTextRenderer().setSmoothingThreshold(6.0f);
        this.panel.getSharedContext().setUserAgentCallback(uac);
        SwingReplacedElementFactory factory = new SwingReplacedElementFactory(this.panel, imageLoader);
        factory.reset();
        this.panel.getSharedContext().setReplacedElementFactory(factory);
        this.panel.getSharedContext().setFontMapping("Raleway", this.resources.getFont("Raleway+FireflySung.ttf", 12.0f));
        SwingUtilities.invokeLater(() -> {
            try {
                Path localCache = fileSystem.getCacheDirectory().resolve("discover.html");
                this.panel.setDocument(this.getDiscoverDocument(runnableAccessDiscover, localCache), runnableAccessDiscover);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.triggerLoadListener();
            }
        });
        this.add((Component)this.panel, "Center");
    }

    public void setLoadListener(ActionListener listener) {
        this.loadListener = listener;
    }

    protected void triggerLoadListener() {
        final ActionListener deferredListener = this.loadListener;
        if (deferredListener != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    deferredListener.actionPerformed(new ActionEvent(this, 0, "loaded"));
                }
            });
            this.loadListener = null;
        }
    }

    protected Document getDiscoverDocument(String url, Path localCache) {
        Document doc = this.getDiscoverDocumentFromLiveSite(url, localCache);
        if (doc != null) {
            return doc;
        }
        if (!Files.exists(localCache, new LinkOption[0]) && (doc = this.getDiscoverDocumentFromLocalCache(localCache)) != null) {
            return doc;
        }
        return this.getDiscoverDocumentFromResource();
    }

    protected Document getDiscoverDocumentFromLiveSite(String url, Path localCache) {
        block27: {
            try {
                byte[] data;
                HttpURLConnection conn = Utils.openHttpConnection(new URL(url));
                try (InputStream stream = conn.getInputStream();){
                    data = IOUtils.toByteArray(stream);
                }
                Document doc = XMLResource.load(new ByteArrayInputStream(data)).getDocument();
                if (doc == null) break block27;
                try (OutputStream stream = Files.newOutputStream(localCache, new OpenOption[0]);){
                    stream.write(data);
                }
                return doc;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Document getDiscoverDocumentFromLocalCache(Path localCache) {
        try (InputStream stream = Files.newInputStream(localCache, new OpenOption[0]);){
            Document document = XMLResource.load(stream).getDocument();
            return document;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Document getDiscoverDocumentFromResource() {
        return XMLResource.load(this.resources.getResourceAsStream("/discoverFallback.html")).getDocument();
    }
}

