/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;
import net.technicpack.launcher.io.LauncherFileSystem;
import net.technicpack.launcher.ui.UIConstants;
import net.technicpack.launcher.ui.listitems.PackBuildItem;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.ui.controls.LauncherDialog;
import net.technicpack.ui.controls.RoundedButton;
import net.technicpack.ui.controls.borders.RoundBorder;
import net.technicpack.ui.controls.list.AdvancedCellRenderer;
import net.technicpack.ui.controls.list.SimpleButtonComboUI;
import net.technicpack.ui.controls.list.popupformatters.RoundedBorderFormatter;
import net.technicpack.ui.lang.ResourceLoader;
import net.technicpack.utilslib.DesktopUtils;

public class ModpackOptionsDialog
extends LauncherDialog {
    private static final int DIALOG_WIDTH = 600;
    private static final int DIALOG_HEIGHT = 380;
    private ModpackModel modpack;
    private ResourceLoader resources;
    private JTextField installField;
    private JRadioButton recommended;
    private JRadioButton latest;
    private JRadioButton manual;
    private JComboBox manualBuildList;
    private JFileChooser chooser;

    public ModpackOptionsDialog(Frame owner, LauncherFileSystem fileSystem, ModpackModel modpack, ResourceLoader resources) {
        super(owner);
        this.modpack = modpack;
        this.resources = resources;
        this.chooser = new JFileChooser(fileSystem.getModpacksDirectory().toFile());
        this.chooser.setFileSelectionMode(1);
        this.initComponents();
        this.initValues();
    }

    public void refresh(ModpackModel model) {
        this.modpack = model;
        this.getContentPane().removeAll();
        this.setLayout(null);
        this.initComponents();
        this.initValues();
    }

    protected void selectRecommended() {
        this.manualBuildList.setBorder(new RoundBorder(UIConstants.COLOR_GREY_TEXT, 1, 10));
        this.manualBuildList.setEnabled(false);
        this.manualBuildList.setSelectedItem(new PackBuildItem(this.modpack.getRecommendedBuild(), this.resources, this.modpack));
        this.modpack.setBuild("recommended");
    }

    protected void selectLatest() {
        this.manualBuildList.setBorder(new RoundBorder(UIConstants.COLOR_GREY_TEXT, 1, 10));
        this.manualBuildList.setEnabled(false);
        this.manualBuildList.setSelectedItem(new PackBuildItem(this.modpack.getLatestBuild(), this.resources, this.modpack));
        this.modpack.setBuild("latest");
    }

    protected void selectManual() {
        if (this.manualBuildList.getItemCount() == 0) {
            return;
        }
        if (this.manualBuildList.getSelectedItem() == null) {
            this.manualBuildList.setSelectedItem(new PackBuildItem(this.modpack.getBuild(), this.resources, this.modpack));
        }
        if (this.manualBuildList.getSelectedItem() == null) {
            this.manualBuildList.setSelectedItem(new PackBuildItem(this.modpack.getRecommendedBuild(), this.resources, this.modpack));
        }
        if (this.manualBuildList.getSelectedIndex() == -1) {
            this.manualBuildList.setSelectedIndex(0);
        }
        this.modpack.setBuild(((PackBuildItem)this.manualBuildList.getSelectedItem()).getBuildNumber());
        this.manualBuildList.setBorder(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 10));
        this.manualBuildList.setEnabled(true);
    }

    protected void buildUpdated() {
        this.modpack.setBuild(((PackBuildItem)this.manualBuildList.getSelectedItem()).getBuildNumber());
    }

    protected void deletePack() {
        int result = JOptionPane.showConfirmDialog(this, this.resources.getString("modpackoptions.delete.confirmtext", new String[0]), this.resources.getString("modpackoptions.delete.confirmtitle", new String[0]), 0, 2);
        if (result == 0) {
            this.modpack.delete();
            this.dispose();
        }
    }

    protected void resetPack() {
        if (this.modpack.isLocalOnly()) {
            JOptionPane.showMessageDialog(this, this.resources.getString("modpackoptions.reinstall.cannotoffline", new String[0]), this.resources.getString("modpackoptions.reinstall.cannottitle", new String[0]), 0);
            return;
        }
        int result = JOptionPane.showConfirmDialog(this, this.resources.getString("modpackoptions.reinstall.confirmtext", new String[0]), this.resources.getString("modpackoptions.reinstall.confirmtitle", new String[0]), 0, 2);
        if (result == 0) {
            this.modpack.resetPack();
            this.dispose();
        }
    }

    protected void openFolder() {
        if (this.modpack.getInstalledDirectory() != null && this.modpack.getInstalledDirectory().exists()) {
            DesktopUtils.open(this.modpack.getInstalledDirectory());
        }
    }

    protected void moveFolder() {
        int result = this.chooser.showOpenDialog(this);
        if (result == 0) {
            File file = this.chooser.getSelectedFile();
            if (file.list().length > 0) {
                JOptionPane.showMessageDialog(this, this.resources.getString("modpackoptions.move.errortext", new String[0]), this.resources.getString("modpackoptions.move.errortitle", new String[0]), 2);
                return;
            }
            this.modpack.setInstalledDirectory(file);
            this.refresh(this.modpack);
        }
    }

    private void initComponents() {
        this.setSize(600, 380);
        this.setLayout(new BorderLayout());
        JPanel header = new JPanel();
        header.setBackground(Color.black);
        header.setLayout(new BoxLayout(header, 2));
        header.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        this.add((Component)header, "First");
        JLabel title = new JLabel(this.resources.getString("launcher.title.modpackoptions", new String[0]));
        title.setFont(this.resources.getFont("Raleway+FireflySung.ttf", 26.0f));
        title.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        title.setForeground(UIConstants.COLOR_WHITE_TEXT);
        title.setOpaque(false);
        title.setIcon(this.resources.getIcon("options_cog.png"));
        header.add(title);
        header.add(Box.createHorizontalGlue());
        JButton closeButton = new JButton();
        closeButton.setIcon(this.resources.getIcon("close.png"));
        closeButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        closeButton.setContentAreaFilled(false);
        closeButton.setCursor(Cursor.getPredefinedCursor(12));
        closeButton.addActionListener(e -> this.closeDialog());
        closeButton.setFocusPainted(false);
        header.add(closeButton);
        JPanel centerPanel = new JPanel();
        centerPanel.setBackground(UIConstants.COLOR_CENTRAL_BACK_OPAQUE);
        centerPanel.setOpaque(true);
        centerPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        this.add((Component)centerPanel, "Center");
        centerPanel.setLayout(new GridBagLayout());
        JLabel installFolderLabel = new JLabel(this.resources.getString("modpackoptions.installfolder.text", new String[0]));
        installFolderLabel.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        installFolderLabel.setForeground(UIConstants.COLOR_WHITE_TEXT);
        centerPanel.add((Component)installFolderLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.installField = new JTextField("");
        this.installField.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.installField.setForeground(UIConstants.COLOR_BLUE);
        this.installField.setBackground(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        this.installField.setHighlighter(null);
        this.installField.setEditable(false);
        this.installField.setCursor(null);
        this.installField.setBorder(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 8));
        centerPanel.add((Component)this.installField, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        RoundedButton openFolder = new RoundedButton(this.resources.getString("modpackoptions.installfolder.open", new String[0]));
        openFolder.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        openFolder.setContentAreaFilled(false);
        openFolder.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        openFolder.setHoverForeground(UIConstants.COLOR_BLUE);
        openFolder.setEnabled(this.modpack.getInstalledDirectory() != null && this.modpack.getInstalledDirectory().exists());
        if (this.modpack.getInstalledDirectory() != null && this.modpack.getInstalledDirectory().exists()) {
            openFolder.setForeground(UIConstants.COLOR_BUTTON_BLUE);
            openFolder.setHoverForeground(UIConstants.COLOR_BLUE);
        } else {
            openFolder.setForeground(UIConstants.COLOR_GREY_TEXT);
        }
        openFolder.addActionListener(e -> this.openFolder());
        centerPanel.add((Component)openFolder, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        RoundedButton moveFolder = new RoundedButton(this.resources.getString("modpackoptions.installfolder.move", new String[0]));
        moveFolder.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        moveFolder.setContentAreaFilled(false);
        moveFolder.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        moveFolder.setHoverForeground(UIConstants.COLOR_BLUE);
        moveFolder.setEnabled(this.modpack.getInstalledDirectory() != null && this.modpack.getInstalledDirectory().exists());
        if (this.modpack.getInstalledDirectory() != null && this.modpack.getInstalledDirectory().exists()) {
            moveFolder.setForeground(UIConstants.COLOR_BUTTON_BLUE);
            moveFolder.setHoverForeground(UIConstants.COLOR_BLUE);
        } else {
            moveFolder.setForeground(UIConstants.COLOR_GREY_TEXT);
        }
        moveFolder.addActionListener(e -> this.moveFolder());
        centerPanel.add((Component)moveFolder, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        centerPanel.add(Box.createVerticalStrut(15), new GridBagConstraints(0, 1, 6, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel buildSelectLabel = new JLabel(this.resources.getString("modpackoptions.version.text", new String[0]));
        buildSelectLabel.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        buildSelectLabel.setForeground(UIConstants.COLOR_WHITE_TEXT);
        centerPanel.add((Component)buildSelectLabel, new GridBagConstraints(0, 2, 6, 1, 1.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.recommended = new JRadioButton(this.resources.getString("modpackoptions.version.recommended", new String[0]));
        this.recommended.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.recommended.setForeground(UIConstants.COLOR_WHITE_TEXT);
        this.recommended.setIcon(this.resources.getIcon("radio_deselected.png"));
        this.recommended.setSelectedIcon(this.resources.getIcon("radio_selected.png"));
        this.recommended.setFocusPainted(false);
        this.recommended.setOpaque(false);
        this.recommended.addActionListener(e -> this.selectRecommended());
        centerPanel.add((Component)this.recommended, new GridBagConstraints(1, 3, 5, 1, 1.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.latest = new JRadioButton(this.resources.getString("modpackoptions.version.latest", new String[0]));
        this.latest.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.latest.setForeground(UIConstants.COLOR_WHITE_TEXT);
        this.latest.setIcon(this.resources.getIcon("radio_deselected.png"));
        this.latest.setSelectedIcon(this.resources.getIcon("radio_selected.png"));
        this.latest.setFocusPainted(false);
        this.latest.setOpaque(false);
        this.latest.addActionListener(e -> this.selectLatest());
        centerPanel.add((Component)this.latest, new GridBagConstraints(1, 4, 5, 1, 1.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.manual = new JRadioButton(this.resources.getString("modpackoptions.version.manual", new String[0]));
        this.manual.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.manual.setForeground(UIConstants.COLOR_WHITE_TEXT);
        this.manual.setIcon(this.resources.getIcon("radio_deselected.png"));
        this.manual.setSelectedIcon(this.resources.getIcon("radio_selected.png"));
        this.manual.setFocusPainted(false);
        this.manual.setOpaque(false);
        this.manual.addActionListener(e -> this.selectManual());
        centerPanel.add((Component)this.manual, new GridBagConstraints(1, 5, 5, 1, 1.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        ButtonGroup versionType = new ButtonGroup();
        versionType.add(this.recommended);
        versionType.add(this.latest);
        versionType.add(this.manual);
        centerPanel.add(Box.createHorizontalStrut(20), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        centerPanel.add(Box.createHorizontalStrut(20), new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.manualBuildList = new JComboBox();
        if (System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("mac")) {
            this.manualBuildList.setUI(new MetalComboBoxUI());
        }
        AdvancedCellRenderer renderer = new AdvancedCellRenderer();
        renderer.setUnselectedBackgroundColor(UIConstants.COLOR_CENTRAL_BACK_OPAQUE);
        renderer.setUnselectedForegroundColor(UIConstants.COLOR_BUTTON_BLUE);
        renderer.setSelectedForegroundColor(UIConstants.COLOR_BUTTON_BLUE);
        renderer.setSelectedBackgroundColor(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        this.manualBuildList.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.manualBuildList.setEditable(false);
        this.manualBuildList.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        this.manualBuildList.setBackground(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        this.manualBuildList.setRenderer(renderer);
        this.manualBuildList.setUI(new SimpleButtonComboUI(new RoundedBorderFormatter(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 0)), this.resources, UIConstants.COLOR_SCROLL_TRACK, UIConstants.COLOR_SCROLL_THUMB));
        this.manualBuildList.setFocusable(false);
        this.manualBuildList.addActionListener(e -> this.buildUpdated());
        Accessible child = this.manualBuildList.getAccessibleContext().getAccessibleChild(0);
        BasicComboPopup popup = (BasicComboPopup)child;
        JList<Object> list = popup.getList();
        list.setSelectionForeground(UIConstants.COLOR_BUTTON_BLUE);
        list.setSelectionBackground(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        list.setBackground(UIConstants.COLOR_CENTRAL_BACK_OPAQUE);
        centerPanel.add((Component)this.manualBuildList, new GridBagConstraints(2, 6, 4, 1, 1.0, 0.0, 17, 3, new Insets(5, 0, 0, 0), 0, 0));
        centerPanel.add(Box.createGlue(), new GridBagConstraints(0, 7, 6, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel bottomButtons = new JPanel();
        bottomButtons.setOpaque(false);
        bottomButtons.setLayout(new BoxLayout(bottomButtons, 2));
        RoundedButton deletePack = new RoundedButton(this.resources.getString("modpackoptions.delete.text", new String[0]));
        deletePack.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        deletePack.setContentAreaFilled(false);
        if (this.modpack.getInstalledDirectory() != null) {
            deletePack.setForeground(UIConstants.COLOR_BUTTON_BLUE);
            deletePack.setHoverForeground(UIConstants.COLOR_BLUE);
        } else {
            deletePack.setForeground(UIConstants.COLOR_GREY_TEXT);
        }
        deletePack.addActionListener(e -> this.deletePack());
        deletePack.setEnabled(this.modpack.getInstalledDirectory() != null);
        bottomButtons.add(deletePack);
        bottomButtons.add(Box.createHorizontalGlue());
        RoundedButton resetPack = new RoundedButton(this.resources.getString("modpackoptions.reinstall.text", new String[0]));
        resetPack.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        resetPack.setContentAreaFilled(false);
        if (this.modpack.getInstalledDirectory() != null) {
            resetPack.setForeground(UIConstants.COLOR_BUTTON_BLUE);
            resetPack.setHoverForeground(UIConstants.COLOR_BLUE);
        } else {
            resetPack.setForeground(UIConstants.COLOR_GREY_TEXT);
        }
        resetPack.addActionListener(e -> this.resetPack());
        resetPack.setEnabled(this.modpack.getInstalledDirectory() != null);
        bottomButtons.add(resetPack);
        centerPanel.add((Component)bottomButtons, new GridBagConstraints(0, 8, 6, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void initValues() {
        File installDir = this.modpack.getInstalledDirectory();
        if (installDir == null) {
            this.installField.setText(this.resources.getString("modpackoptions.installfolder.none", new String[0]));
        } else {
            this.installField.setText(installDir.getAbsolutePath());
        }
        for (String build : this.modpack.getBuilds()) {
            this.manualBuildList.insertItemAt(new PackBuildItem(build, this.resources, this.modpack), 0);
        }
        if (this.manualBuildList.getItemCount() == 0) {
            this.recommended.setEnabled(false);
            this.latest.setEnabled(false);
            this.manual.setEnabled(false);
            this.recommended.setSelected(true);
            this.manualBuildList.addItem(new PackBuildItem(this.resources.getString("modpackoptions.version.missing", new String[0]), this.resources, this.modpack));
            this.manualBuildList.setEnabled(false);
            return;
        }
        String build = this.modpack.getBuild();
        if (build.equals("recommended")) {
            this.recommended.setSelected(true);
            this.selectRecommended();
        } else if (build.equals("latest")) {
            this.latest.setSelected(true);
            this.selectLatest();
        } else {
            this.manual.setSelected(true);
            this.selectManual();
        }
    }

    protected void closeDialog() {
        this.dispose();
    }
}

