/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.technicpack.autoupdate.IBuildNumber;
import net.technicpack.discord.IDiscordApi;
import net.technicpack.launcher.io.InstalledPackStore;
import net.technicpack.launcher.io.LauncherFileSystem;
import net.technicpack.launcher.launch.Installer;
import net.technicpack.launcher.settings.StartupParameters;
import net.technicpack.launcher.settings.TechnicSettings;
import net.technicpack.launcher.ui.UIConstants;
import net.technicpack.launcher.ui.components.ModpackOptionsDialog;
import net.technicpack.launcher.ui.components.OptionsDialog;
import net.technicpack.launcher.ui.components.discover.DiscoverInfoPanel;
import net.technicpack.launcher.ui.components.modpacks.ModpackInfoPanel;
import net.technicpack.launcher.ui.components.modpacks.ModpackSelector;
import net.technicpack.launcher.ui.components.news.NewsInfoPanel;
import net.technicpack.launcher.ui.components.news.NewsSelector;
import net.technicpack.launcher.ui.controls.HeaderTab;
import net.technicpack.launcher.ui.controls.UserWidget;
import net.technicpack.launchercore.auth.IAuthListener;
import net.technicpack.launchercore.auth.IUserType;
import net.technicpack.launchercore.auth.UserModel;
import net.technicpack.launchercore.image.ImageRepository;
import net.technicpack.launchercore.install.ModpackVersion;
import net.technicpack.launchercore.launch.java.JavaVersionRepository;
import net.technicpack.launchercore.launch.java.source.FileJavaSource;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.platform.IPlatformApi;
import net.technicpack.platform.io.AuthorshipInfo;
import net.technicpack.rest.io.PackInfo;
import net.technicpack.ui.controls.DraggableFrame;
import net.technicpack.ui.controls.RoundedButton;
import net.technicpack.ui.controls.SplatPane;
import net.technicpack.ui.controls.TintablePanel;
import net.technicpack.ui.controls.feeds.CountCircle;
import net.technicpack.ui.controls.installation.ProgressBar;
import net.technicpack.ui.lang.IRelocalizableResource;
import net.technicpack.ui.lang.ResourceLoader;
import net.technicpack.utilslib.DesktopUtils;

public class LauncherFrame
extends DraggableFrame
implements IRelocalizableResource,
IAuthListener {
    public static final String TAB_DISCOVER = "discover";
    public static final String TAB_MODPACKS = "modpacks";
    public static final String TAB_NEWS = "news";
    private static final int FRAME_WIDTH = 1194;
    private static final int FRAME_HEIGHT = 718;
    private ResourceLoader resources;
    private final UserModel userModel;
    private final ImageRepository<IUserType> skinRepository;
    private final TechnicSettings settings;
    private final ImageRepository<ModpackModel> iconRepo;
    private final ImageRepository<ModpackModel> logoRepo;
    private final ImageRepository<ModpackModel> backgroundRepo;
    private final ImageRepository<AuthorshipInfo> avatarRepo;
    private final Installer installer;
    private final IPlatformApi platformApi;
    private final LauncherFileSystem fileSystem;
    private final InstalledPackStore packRepo;
    private final StartupParameters params;
    private final JavaVersionRepository javaVersions;
    private final FileJavaSource fileJavaSource;
    private final IBuildNumber buildNumber;
    private final IDiscordApi discordApi;
    private final AtomicBoolean launchCompletedRequested = new AtomicBoolean(false);
    private ModpackOptionsDialog modpackOptionsDialog = null;
    private HeaderTab discoverTab;
    private HeaderTab modpacksTab;
    private HeaderTab newsTab;
    private CardLayout infoLayout;
    private JPanel infoSwap;
    private UserWidget userWidget;
    private ProgressBar installProgress;
    private Component installProgressPlaceholder;
    private RoundedButton playButton;
    private ModpackSelector modpackSelector;
    private NewsSelector newsSelector;
    private TintablePanel centralPanel;
    private TintablePanel footer;
    private String currentTabName;
    NewsInfoPanel newsInfoPanel;
    ModpackInfoPanel modpackPanel;
    DiscoverInfoPanel discoverInfoPanel;

    public LauncherFrame(ResourceLoader resources, ImageRepository<IUserType> skinRepository, UserModel userModel, TechnicSettings settings, ModpackSelector modpackSelector, ImageRepository<ModpackModel> iconRepo, ImageRepository<ModpackModel> logoRepo, ImageRepository<ModpackModel> backgroundRepo, Installer installer, ImageRepository<AuthorshipInfo> avatarRepo, IPlatformApi platformApi, LauncherFileSystem fileSystem, InstalledPackStore packStore, StartupParameters params, DiscoverInfoPanel discoverInfoPanel, JavaVersionRepository javaVersions, FileJavaSource fileJavaSource, IBuildNumber buildNumber, IDiscordApi discordApi) {
        this.setSize(1194, 718);
        this.setDefaultCloseOperation(3);
        this.setTitle("Technic Launcher");
        this.userModel = userModel;
        this.skinRepository = skinRepository;
        this.settings = settings;
        this.modpackSelector = modpackSelector;
        this.iconRepo = iconRepo;
        this.logoRepo = logoRepo;
        this.backgroundRepo = backgroundRepo;
        this.installer = installer;
        this.avatarRepo = avatarRepo;
        this.platformApi = platformApi;
        this.fileSystem = fileSystem;
        this.packRepo = packStore;
        this.params = params;
        this.discoverInfoPanel = discoverInfoPanel;
        this.fileJavaSource = fileJavaSource;
        this.javaVersions = javaVersions;
        this.buildNumber = buildNumber;
        this.discordApi = discordApi;
        this.relocalize(resources);
        this.selectTab(TAB_DISCOVER);
        this.setLocationRelativeTo(null);
    }

    public void selectTab(String tabName) {
        this.discoverTab.setIsActive(false);
        this.modpacksTab.setIsActive(false);
        this.newsTab.setIsActive(false);
        if (tabName.equalsIgnoreCase(TAB_DISCOVER)) {
            this.discoverTab.setIsActive(true);
        } else if (tabName.equalsIgnoreCase(TAB_MODPACKS)) {
            this.modpacksTab.setIsActive(true);
        } else if (tabName.equalsIgnoreCase(TAB_NEWS)) {
            this.newsTab.setIsActive(true);
            this.newsSelector.ping();
        }
        this.infoLayout.show(this.infoSwap, tabName);
        this.currentTabName = tabName;
    }

    protected void closeWindow() {
        System.exit(0);
    }

    protected void minimizeWindow() {
        this.setState(1);
    }

    protected void logout() {
        if (this.installer.isCurrentlyRunning()) {
            return;
        }
        this.userModel.setCurrentUser(null);
    }

    protected void launchModpack() {
        int result;
        boolean requestInstall;
        ModpackModel pack = this.modpackSelector.getSelectedPack();
        boolean requiresInstall = false;
        if (pack == null || pack.getInstalledPack() == null && (pack.getPackInfo() == null || !pack.getPackInfo().isComplete())) {
            return;
        }
        if (pack.getInstalledDirectory() == null) {
            requiresInstall = true;
            pack.save();
            this.modpackSelector.forceRefresh();
        }
        boolean forceInstall = false;
        ModpackVersion installedVersion = pack.getInstalledVersion();
        if (installedVersion == null) {
            forceInstall = true;
            requiresInstall = true;
        } else if (pack.getBuild() != null && !pack.isLocalOnly() && (requestInstall = LauncherFrame.shouldRequestInstall(pack, installedVersion)) && (result = JOptionPane.showConfirmDialog(this, this.resources.getString("launcher.install.query", new String[0]), this.resources.getString("launcher.install.query.title", new String[0]), 0, 1)) == 0) {
            forceInstall = true;
        }
        String installBuild = LauncherFrame.getInstallBuild(forceInstall, pack, installedVersion);
        if (requiresInstall) {
            this.installer.justInstall(this.resources, pack, installBuild, forceInstall, this, this.installProgress);
        } else {
            this.installer.installAndRun(this.resources, pack, installBuild, forceInstall, this, this.installProgress);
        }
        this.installProgress.stateChanged("Initializing...", 0.0f);
        this.installProgress.setVisible(true);
        this.installProgressPlaceholder.setVisible(false);
        this.userChanged(this.userModel.getCurrentUser());
        this.invalidate();
    }

    private static boolean shouldRequestInstall(ModpackModel pack, ModpackVersion installedVersion) {
        String installedBuild = installedVersion.getVersion();
        String wantedBuild = pack.getBuild();
        boolean wantsRecommended = wantedBuild.equalsIgnoreCase("recommended");
        boolean wantsLatest = wantedBuild.equalsIgnoreCase("latest");
        PackInfo packInfo = pack.getPackInfo();
        String recommendedBuild = packInfo.getRecommended();
        String latestBuild = packInfo.getLatest();
        return wantsRecommended && recommendedBuild != null && !recommendedBuild.equalsIgnoreCase(installedBuild) || wantsLatest && latestBuild != null && !latestBuild.equalsIgnoreCase(installedBuild) || !wantsRecommended && !wantsLatest && !wantedBuild.equalsIgnoreCase(installedBuild);
    }

    private static String getInstallBuild(boolean forceInstall, ModpackModel pack, ModpackVersion installedVersion) {
        String installBuild = null;
        if (forceInstall && !pack.isLocalOnly()) {
            installBuild = pack.getBuild();
            if (installBuild.equalsIgnoreCase("recommended")) {
                installBuild = pack.getPackInfo().getRecommended();
            } else if (installBuild.equalsIgnoreCase("latest")) {
                installBuild = pack.getPackInfo().getLatest();
            }
        } else if (installedVersion != null) {
            installBuild = installedVersion.getVersion();
        }
        return installBuild;
    }

    public void launchCompleted() {
        if (!this.launchCompletedRequested.compareAndSet(false, true)) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this::launchCompleted);
            return;
        }
        try {
            this.installProgress.setVisible(false);
            this.installProgressPlaceholder.setVisible(true);
            this.userModel.setCurrentUser(this.userModel.getCurrentUser());
            this.invalidate();
        }
        finally {
            this.launchCompletedRequested.set(false);
        }
    }

    protected void openModpackOptions(ModpackModel model) {
        if (this.modpackOptionsDialog == null) {
            this.centralPanel.setTintActive(true);
            this.footer.setTintActive(true);
            this.modpackOptionsDialog = new ModpackOptionsDialog((Frame)this, this.fileSystem, model, this.resources);
            this.modpackOptionsDialog.setVisible(true);
            this.modpackOptionsDialog = null;
            this.centralPanel.setTintActive(false);
            this.footer.setTintActive(false);
            this.modpackPanel.setModpack(model);
            this.modpackSelector.forceRefresh();
        }
    }

    protected void refreshModpackOptions(ModpackModel model) {
        if (this.modpackOptionsDialog != null) {
            this.modpackOptionsDialog.refresh(model);
        }
    }

    protected void openLauncherOptions() {
        this.centralPanel.setTintActive(true);
        this.footer.setTintActive(true);
        OptionsDialog dialog = new OptionsDialog(this, this.settings, this.resources, this.params, this.javaVersions, this.fileJavaSource, this.buildNumber);
        dialog.setVisible(true);
        this.centralPanel.setTintActive(false);
        this.footer.setTintActive(false);
    }

    private void initComponents() {
        BorderLayout layout = new BorderLayout();
        this.getRootPane().getContentPane().setLayout(layout);
        JPanel header = new JPanel();
        header.setLayout(new BoxLayout(header, 2));
        header.setBackground(UIConstants.COLOR_BLUE);
        header.setForeground(UIConstants.COLOR_WHITE_TEXT);
        header.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 10));
        this.getRootPane().getContentPane().add((Component)header, "First");
        ImageIcon headerIcon = this.resources.getIcon("platform_icon_title.png");
        JButton headerLabel = new JButton(headerIcon);
        headerLabel.setBorder(BorderFactory.createEmptyBorder(5, 8, 5, 0));
        headerLabel.setContentAreaFilled(false);
        headerLabel.setFocusPainted(false);
        headerLabel.setCursor(Cursor.getPredefinedCursor(12));
        headerLabel.addActionListener(e -> DesktopUtils.browseUrl("https://www.technicpack.net/"));
        header.add(headerLabel);
        header.add(Box.createRigidArea(new Dimension(6, 0)));
        ActionListener tabListener = e -> this.selectTab(e.getActionCommand());
        this.discoverTab = new HeaderTab(this.resources.getString("launcher.title.discover", new String[0]), this.resources);
        header.add(this.discoverTab);
        this.discoverTab.setActionCommand(TAB_DISCOVER);
        this.discoverTab.addActionListener(tabListener);
        this.modpacksTab = new HeaderTab(this.resources.getString("launcher.title.modpacks", new String[0]), this.resources);
        this.modpacksTab.setIsActive(true);
        this.modpacksTab.setHorizontalTextPosition(10);
        this.modpacksTab.addActionListener(tabListener);
        this.modpacksTab.setActionCommand(TAB_MODPACKS);
        header.add(this.modpacksTab);
        this.newsTab = new HeaderTab(this.resources.getString("launcher.title.news", new String[0]), this.resources);
        this.newsTab.setLayout(null);
        this.newsTab.addActionListener(tabListener);
        this.newsTab.setActionCommand(TAB_NEWS);
        header.add(this.newsTab);
        CountCircle newsCircle = new CountCircle();
        newsCircle.setBackground(UIConstants.COLOR_RED);
        newsCircle.setForeground(UIConstants.COLOR_WHITE_TEXT);
        newsCircle.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f, 1));
        this.newsTab.add(newsCircle);
        newsCircle.setBounds(10, 17, 25, 25);
        header.add(Box.createHorizontalGlue());
        JPanel rightHeaderPanel = new JPanel();
        rightHeaderPanel.setOpaque(false);
        rightHeaderPanel.setLayout(new BoxLayout(rightHeaderPanel, 3));
        rightHeaderPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        JPanel windowGadgetPanel = new JPanel();
        windowGadgetPanel.setOpaque(false);
        windowGadgetPanel.setLayout(new BoxLayout(windowGadgetPanel, 2));
        windowGadgetPanel.setAlignmentX(1.0f);
        ImageIcon minimizeIcon = this.resources.getIcon("minimize.png");
        JButton minimizeButton = new JButton(minimizeIcon);
        minimizeButton.setBorder(BorderFactory.createEmptyBorder());
        minimizeButton.setContentAreaFilled(false);
        minimizeButton.setCursor(new Cursor(12));
        minimizeButton.setFocusable(false);
        minimizeButton.addActionListener(e -> this.minimizeWindow());
        windowGadgetPanel.add(minimizeButton);
        ImageIcon closeIcon = this.resources.getIcon("close.png");
        JButton closeButton = new JButton(closeIcon);
        closeButton.setBorder(BorderFactory.createEmptyBorder());
        closeButton.setContentAreaFilled(false);
        closeButton.addActionListener(e -> this.closeWindow());
        closeButton.setCursor(new Cursor(12));
        closeButton.setFocusable(false);
        windowGadgetPanel.add(closeButton);
        rightHeaderPanel.add(windowGadgetPanel);
        rightHeaderPanel.add(Box.createVerticalGlue());
        JButton launcherOptionsLabel = new JButton(this.resources.getString("launcher.title.options", new String[0]));
        launcherOptionsLabel.setIcon(this.resources.getIcon("options_cog.png"));
        launcherOptionsLabel.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 14.0f));
        launcherOptionsLabel.setForeground(UIConstants.COLOR_WHITE_TEXT);
        launcherOptionsLabel.setHorizontalAlignment(4);
        launcherOptionsLabel.setHorizontalTextPosition(10);
        launcherOptionsLabel.setAlignmentX(1.0f);
        launcherOptionsLabel.setCursor(Cursor.getPredefinedCursor(12));
        launcherOptionsLabel.setBorder(BorderFactory.createEmptyBorder());
        launcherOptionsLabel.setContentAreaFilled(false);
        launcherOptionsLabel.setFocusPainted(false);
        launcherOptionsLabel.addActionListener(e -> this.openLauncherOptions());
        rightHeaderPanel.add(launcherOptionsLabel);
        header.add(rightHeaderPanel);
        this.centralPanel = new TintablePanel();
        this.centralPanel.setBackground(UIConstants.COLOR_CHARCOAL);
        this.centralPanel.setForeground(UIConstants.COLOR_WHITE_TEXT);
        this.centralPanel.setTintColor(UIConstants.COLOR_CENTRAL_BACK);
        this.getRootPane().getContentPane().add((Component)this.centralPanel, "Center");
        this.centralPanel.setLayout(new BorderLayout());
        this.modpackPanel = new ModpackInfoPanel(this.resources, this.iconRepo, this.logoRepo, this.backgroundRepo, this.avatarRepo, this.discordApi, e -> this.openModpackOptions((ModpackModel)e.getSource()), e -> this.refreshModpackOptions((ModpackModel)e.getSource()));
        this.modpackSelector.setInfoPanel(this.modpackPanel);
        this.modpackSelector.setLauncherFrame(this);
        this.playButton = this.modpackPanel.getPlayButton();
        this.playButton.addActionListener(e -> {
            if (e.getSource() instanceof ModpackModel) {
                this.setupPlayButtonText((ModpackModel)e.getSource(), this.userModel.getCurrentUser());
            } else if (this.installer.isCurrentlyRunning()) {
                this.installer.cancel();
                this.setupPlayButtonText(this.modpackSelector.getSelectedPack(), this.userModel.getCurrentUser());
            } else {
                this.launchModpack();
            }
        });
        this.modpackPanel.getDeleteButton().addActionListener(e -> {
            if (JOptionPane.showConfirmDialog(this, this.resources.getString("modpackoptions.delete.confirmtext", new String[0]), this.resources.getString("modpackoptions.delete.confirmtitle", new String[0]), 0) == 0) {
                this.modpackSelector.getSelectedPack().delete();
                this.modpackSelector.forceRefresh();
            }
        });
        this.infoSwap = new JPanel();
        this.infoLayout = new CardLayout();
        this.infoSwap.setLayout(this.infoLayout);
        this.infoSwap.setOpaque(false);
        this.newsInfoPanel = new NewsInfoPanel(this.resources, this.avatarRepo);
        this.infoSwap.add((Component)this.discoverInfoPanel, TAB_DISCOVER);
        JPanel newsHost = new JPanel();
        this.infoSwap.add((Component)newsHost, TAB_NEWS);
        JPanel modpackHost = new JPanel();
        this.infoSwap.add((Component)modpackHost, TAB_MODPACKS);
        this.centralPanel.add((Component)this.infoSwap, "Center");
        this.newsSelector = new NewsSelector(this.resources, this.newsInfoPanel, this.platformApi, this.avatarRepo, newsCircle, this.settings);
        newsHost.setLayout(new BorderLayout());
        newsHost.add((Component)this.newsInfoPanel, "Center");
        newsHost.add((Component)this.newsSelector, "West");
        modpackHost.setLayout(new BorderLayout());
        modpackHost.add((Component)this.modpackPanel, "Center");
        modpackHost.add((Component)this.modpackSelector, "West");
        this.footer = new TintablePanel();
        this.footer.setTintColor(UIConstants.COLOR_CENTRAL_BACK);
        this.footer.setBackground(UIConstants.COLOR_FOOTER);
        this.footer.setLayout(new BoxLayout(this.footer, 2));
        this.footer.setForeground(UIConstants.COLOR_WHITE_TEXT);
        this.footer.setBorder(BorderFactory.createEmptyBorder(3, 6, 3, 12));
        this.userWidget = new UserWidget(this.resources, this.skinRepository);
        this.userWidget.setMaximumSize(this.userWidget.getPreferredSize());
        this.footer.add(this.userWidget);
        JLabel dashText = new JLabel("| ");
        dashText.setForeground(UIConstants.COLOR_WHITE_TEXT);
        dashText.setFont(this.resources.getFont("Raleway+FireflySung.ttf", 15.0f));
        this.footer.add(dashText);
        JButton logout = new JButton(this.resources.getString("launcher.user.logout", new String[0]));
        logout.setBorder(BorderFactory.createEmptyBorder());
        logout.setContentAreaFilled(false);
        logout.setFocusable(false);
        logout.setForeground(UIConstants.COLOR_WHITE_TEXT);
        logout.setCursor(Cursor.getPredefinedCursor(12));
        logout.setFont(this.resources.getFont("Raleway+FireflySung.ttf", 15.0f));
        logout.addActionListener(e -> this.logout());
        this.footer.add(logout);
        this.installProgress = new ProgressBar();
        this.installProgress.setForeground(Color.white);
        this.installProgress.setBackground(UIConstants.COLOR_GREEN);
        this.installProgress.setBorder(BorderFactory.createEmptyBorder(5, 45, 4, 45));
        this.installProgress.setIcon(this.resources.getIcon("download_icon.png"));
        this.installProgress.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 12.0f));
        this.installProgress.setVisible(false);
        this.footer.add(this.installProgress);
        this.installProgressPlaceholder = Box.createHorizontalGlue();
        this.footer.add(this.installProgressPlaceholder);
        JButton buildCtrl = new JButton(this.resources.getIcon("akliz-logo.png"));
        buildCtrl.setBorder(BorderFactory.createEmptyBorder());
        buildCtrl.setContentAreaFilled(false);
        buildCtrl.setHorizontalTextPosition(4);
        buildCtrl.setHorizontalAlignment(4);
        buildCtrl.setFocusable(false);
        buildCtrl.setCursor(Cursor.getPredefinedCursor(12));
        buildCtrl.addActionListener(e -> DesktopUtils.browseUrl("https://www.akliz.net/technic"));
        this.footer.add(buildCtrl);
        this.getRootPane().getContentPane().add((Component)this.footer, "Last");
        if (this.resources.hasResource("teaser.png")) {
            this.getRootPane().setGlassPane(new SplatPane(this.modpacksTab, this.resources.getIcon("teaser.png"), 5, 5, 0));
            this.getRootPane().getGlassPane().setVisible(true);
        }
    }

    @Override
    public void relocalize(ResourceLoader loader) {
        this.resources = loader;
        this.resources.registerResource(this);
        this.setIconImage(this.resources.getImage("icon.png"));
        this.getRootPane().getContentPane().removeAll();
        this.getRootPane().getContentPane().setLayout(null);
        this.initComponents();
        this.userChanged(this.userModel.getCurrentUser());
        if (this.currentTabName != null) {
            this.selectTab(this.currentTabName);
        }
        SwingUtilities.invokeLater(() -> {
            this.invalidate();
            this.repaint();
        });
    }

    @Override
    public void userChanged(IUserType user) {
        if (user == null) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
            this.userWidget.setUser(user);
            if (this.modpackSelector.getSelectedPack() != null) {
                this.setupPlayButtonText(this.modpackSelector.getSelectedPack(), user);
            }
            this.modpackSelector.forceRefresh();
            SwingUtilities.invokeLater(this::repaint);
        }
    }

    public void setupPlayButtonText(ModpackModel modpack, IUserType user) {
        boolean isUserOffline;
        this.playButton.setEnabled(true);
        this.playButton.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        boolean bl = isUserOffline = user != null && user.isOffline();
        if (this.installer.isCurrentlyRunning()) {
            this.playButton.setText(this.resources.getString("launcher.pack.cancel", new String[0]));
        } else if (modpack.getInstalledVersion() != null) {
            if (isUserOffline) {
                this.playButton.setText(this.resources.getString("launcher.pack.launch.offline", new String[0]));
            } else {
                this.playButton.setText(this.resources.getString("launcher.pack.launch", new String[0]));
            }
            this.playButton.setIcon(new ImageIcon(this.resources.colorImage(this.resources.getImage("play_button.png"), UIConstants.COLOR_BUTTON_BLUE)));
            this.playButton.setHoverIcon(new ImageIcon(this.resources.colorImage(this.resources.getImage("play_button.png"), UIConstants.COLOR_BLUE)));
        } else {
            if (isUserOffline) {
                this.playButton.setEnabled(false);
                this.playButton.setForeground(UIConstants.COLOR_GREY_TEXT);
                this.playButton.setText(this.resources.getString("launcher.pack.cannotinstall", new String[0]));
            } else {
                this.playButton.setText(this.resources.getString("launcher.pack.install", new String[0]));
            }
            this.playButton.setIcon(new ImageIcon(this.resources.colorImage(this.resources.getImage("download_button.png"), UIConstants.COLOR_BUTTON_BLUE)));
            this.playButton.setHoverIcon(new ImageIcon(this.resources.colorImage(this.resources.getImage("download_button.png"), UIConstants.COLOR_BLUE)));
        }
    }
}

