/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import net.technicpack.autoupdate.Relauncher;
import net.technicpack.autoupdate.tasks.CopyLauncherPackage;
import net.technicpack.launcher.autoupdate.VersionFileBuildNumber;
import net.technicpack.launcher.io.LauncherFileSystem;
import net.technicpack.launcher.settings.StartupParameters;
import net.technicpack.launcher.settings.TechnicSettings;
import net.technicpack.launcher.ui.UIConstants;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.ui.UIUtils;
import net.technicpack.ui.controls.DraggableFrame;
import net.technicpack.ui.controls.RoundedButton;
import net.technicpack.ui.controls.borders.RoundBorder;
import net.technicpack.ui.controls.lang.LanguageCellRenderer;
import net.technicpack.ui.controls.lang.LanguageCellUI;
import net.technicpack.ui.controls.list.popupformatters.RoundedBorderFormatter;
import net.technicpack.ui.controls.tabs.SimpleTabPane;
import net.technicpack.ui.lang.IRelocalizableResource;
import net.technicpack.ui.lang.ResourceLoader;
import net.technicpack.ui.listitems.LanguageItem;
import net.technicpack.utilslib.OperatingSystem;
import net.technicpack.utilslib.Utils;
import org.apache.commons.io.FileUtils;

public class InstallerFrame
extends DraggableFrame
implements IRelocalizableResource {
    private static final int DIALOG_WIDTH = 610;
    private static final int DIALOG_HEIGHT = 320;
    private ResourceLoader resources;
    private Window mainFrame;
    private JCheckBox standardDefaultDirectory;
    private JTextField standardInstallDir;
    private RoundedButton standardSelectButton;
    private JTextField portableInstallDir;
    private RoundedButton portableInstallButton;
    private StartupParameters params;
    private JComboBox standardLanguages;
    private JComboBox portableLanguages;
    private TechnicSettings settings;
    private JPanel glassPane;

    public InstallerFrame(ResourceLoader resources, StartupParameters params) {
        this.resources = resources;
        this.params = params;
        this.settings = new TechnicSettings();
        this.settings.setFilePath(new File(OperatingSystem.getOperatingSystem().getTechnicDirectory(), "settings.json"));
        this.settings.getTechnicRoot();
        this.addGlassPane();
        this.setDefaultCloseOperation(2);
        this.relocalize(resources);
    }

    public InstallerFrame(ResourceLoader resources, StartupParameters params, TechnicSettings settings, Window mainFrame) {
        this.settings = settings;
        this.resources = resources;
        this.params = params;
        this.mainFrame = mainFrame;
        if (mainFrame != null) {
            mainFrame.setVisible(false);
        }
        this.addGlassPane();
        this.relocalize(resources);
    }

    private void addGlassPane() {
        this.glassPane = new JPanel(){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(UIConstants.COLOR_CENTRAL_BACK);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        this.glassPane.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                e.consume();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                e.consume();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                e.consume();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                e.consume();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                e.consume();
            }
        });
        this.glassPane.setOpaque(false);
        this.glassPane.setLayout(new GridBagLayout());
        JLabel spinner = new JLabel(this.resources.getIcon("loader.gif"));
        this.glassPane.add(spinner);
        this.setGlassPane(this.glassPane);
    }

    protected void standardLanguageChanged() {
        String langCode = ((LanguageItem)this.standardLanguages.getSelectedItem()).getLangCode();
        this.settings.setLanguageCode(langCode);
        this.resources.setLocale(langCode);
    }

    protected void portableLanguageChanged() {
        String langCode = ((LanguageItem)this.portableLanguages.getSelectedItem()).getLangCode();
        this.settings.setLanguageCode(langCode);
        this.resources.setLocale(langCode);
    }

    protected void standardInstall() {
        this.glassPane.setVisible(true);
        Thread thread = new Thread(() -> {
            File oldSettings = this.settings.getFilePath();
            File newSettings = new File(OperatingSystem.getOperatingSystem().getTechnicDirectory(), "settings.json");
            if (oldSettings.exists() && !oldSettings.getAbsolutePath().equals(newSettings.getAbsolutePath())) {
                oldSettings.delete();
            }
            File oldRoot = this.settings.getTechnicRoot();
            File newRoot = new File(this.standardInstallDir.getText());
            boolean rootHasChanged = false;
            if (oldRoot.exists() && !oldRoot.getAbsolutePath().equals(newRoot.getAbsolutePath())) {
                rootHasChanged = true;
                try {
                    if (!newRoot.exists()) {
                        newRoot.mkdirs();
                    }
                    FileUtils.copyDirectory(oldRoot, newRoot);
                    FileUtils.deleteDirectory(oldRoot);
                }
                catch (IOException e) {
                    Utils.getLogger().log(Level.SEVERE, "Copying install to new directory failed: ", e);
                }
            }
            this.settings.setFilePath(newSettings);
            if (this.settings.isPortable() || rootHasChanged || !this.standardInstallDir.getText().equals(OperatingSystem.getOperatingSystem().getTechnicDirectory().getAbsolutePath())) {
                this.settings.installTo(this.standardInstallDir.getText());
            }
            this.settings.getTechnicRoot();
            this.settings.setLanguageCode(((LanguageItem)this.standardLanguages.getSelectedItem()).getLangCode());
            this.settings.save();
            Path installedPacks = newRoot.toPath().resolve("installedPacks");
            try {
                if (!Files.exists(installedPacks, new LinkOption[0])) {
                    Files.createFile(installedPacks, new FileAttribute[0]);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Path usersJson = newRoot.toPath().resolve("users.json");
            try {
                if (!Files.exists(usersJson, new LinkOption[0])) {
                    Files.createFile(usersJson, new FileAttribute[0]);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            VersionFileBuildNumber buildNumber = new VersionFileBuildNumber(this.resources);
            Utils.sendTracking("installLauncher", "standard", buildNumber.getBuildNumber(), this.settings.getClientId());
            Relauncher relauncher = new Relauncher(null, this.settings.getBuildStream(), 0, new LauncherFileSystem(this.settings.getTechnicRootPath()), this.resources, this.params);
            String currentPath = relauncher.getRunningPath();
            relauncher.launch(currentPath, this.params.getArgs());
            System.exit(0);
        });
        thread.start();
    }

    protected void portableInstall() {
        Relauncher relauncher = new Relauncher(null, this.settings.getBuildStream(), 0, new LauncherFileSystem(this.settings.getTechnicRootPath()), this.resources, this.params);
        String currentPath = relauncher.getRunningPath();
        String launcher = currentPath.endsWith(".exe") ? "TechnicLauncher.exe" : "TechnicLauncher.jar";
        String targetPath = new File(this.portableInstallDir.getText(), launcher).getAbsolutePath();
        File targetExe = new File(this.portableInstallDir.getText(), launcher);
        if (!new File(currentPath).equals(targetExe)) {
            if (targetExe.exists() && !targetExe.delete()) {
                JOptionPane.showMessageDialog(this, this.resources.getString("installer.portable.replacefailed", new String[0]), this.resources.getString("installer.portable.replacefailtitle", new String[0]), 0);
                return;
            }
            CopyLauncherPackage copyTask = new CopyLauncherPackage("", targetExe, relauncher);
            try {
                copyTask.runTask((InstallTasksQueue<Void>)null);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, this.resources.getString("installer.portable.replacefailed", new String[0]), this.resources.getString("installer.portable.replacefailtitle", new String[0]), 0);
                return;
            }
        }
        this.glassPane.setVisible(true);
        String threadTargetPath = targetPath;
        Thread thread = new Thread(() -> {
            File oldRoot = this.settings.getTechnicRoot();
            File newRoot = new File(this.portableInstallDir.getText(), "technic");
            File oldSettingsFile = this.settings.getFilePath();
            File newSettingsFile = new File(newRoot, "settings.json");
            if (oldSettingsFile.exists() && !oldSettingsFile.getAbsolutePath().equals(newSettingsFile.getAbsolutePath())) {
                oldSettingsFile.delete();
            }
            if (oldRoot.exists() && !oldRoot.getAbsolutePath().equals(newRoot.getAbsolutePath())) {
                try {
                    if (!newRoot.exists()) {
                        newRoot.mkdirs();
                    }
                    FileUtils.copyDirectory(oldRoot, newRoot);
                    FileUtils.deleteDirectory(oldRoot);
                }
                catch (IOException e) {
                    Utils.getLogger().log(Level.SEVERE, "Copying install to new directory failed: ", e);
                }
            }
            this.settings.setPortable();
            this.settings.setFilePath(newSettingsFile);
            this.settings.getTechnicRoot();
            this.settings.setLanguageCode(((LanguageItem)this.portableLanguages.getSelectedItem()).getLangCode());
            this.settings.save();
            Path installedPacks = newRoot.toPath().resolve("installedPacks");
            try {
                if (!Files.exists(installedPacks, new LinkOption[0])) {
                    Files.createFile(installedPacks, new FileAttribute[0]);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Path usersJson = newRoot.toPath().resolve("users.json");
            try {
                if (!Files.exists(usersJson, new LinkOption[0])) {
                    Files.createFile(usersJson, new FileAttribute[0]);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            VersionFileBuildNumber buildNumber = new VersionFileBuildNumber(this.resources);
            Utils.sendTracking("installLauncher", "portable", buildNumber.getBuildNumber(), this.settings.getClientId());
            relauncher.launch(threadTargetPath, this.params.getArgs());
            System.exit(0);
        });
        thread.start();
    }

    protected void selectPortable() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        int result = chooser.showOpenDialog(this);
        if (result == 0) {
            this.portableInstallDir.setText(chooser.getSelectedFile().getAbsolutePath());
            this.portableInstallButton.setForeground(UIConstants.COLOR_BUTTON_BLUE);
            this.portableInstallButton.setEnabled(true);
        }
    }

    protected void selectStandard() {
        File installDir = new File(this.standardInstallDir.getText());
        while (!installDir.exists()) {
            installDir = installDir.getParentFile();
        }
        JFileChooser chooser = new JFileChooser(installDir);
        chooser.setFileSelectionMode(1);
        int result = chooser.showOpenDialog(this);
        if (result == 0) {
            File[] files = chooser.getSelectedFile().listFiles();
            if (files == null || files.length > 0) {
                JOptionPane.showMessageDialog(this, this.resources.getString("modpackoptions.move.errortext", new String[0]), this.resources.getString("modpackoptions.move.errortitle", new String[0]), 0);
                return;
            }
            this.standardInstallDir.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    protected void useDefaultDirectoryChanged() {
        if (!this.standardDefaultDirectory.isSelected()) {
            this.standardInstallDir.setForeground(UIConstants.COLOR_BUTTON_BLUE);
            this.standardInstallDir.setBorder(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 10));
            this.standardSelectButton.setEnabled(true);
            this.standardSelectButton.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        } else {
            this.standardInstallDir.setForeground(UIConstants.COLOR_SCROLL_THUMB);
            this.standardInstallDir.setBorder(new RoundBorder(UIConstants.COLOR_SCROLL_THUMB, 1, 10));
            this.standardSelectButton.setEnabled(false);
            this.standardSelectButton.setForeground(UIConstants.COLOR_GREY_TEXT);
            this.standardInstallDir.setText(OperatingSystem.getOperatingSystem().getTechnicDirectory().getAbsolutePath());
        }
    }

    private void initComponents() {
        this.setSize(610, 320);
        this.setIconImage(this.resources.getImage("icon.png"));
        this.setLayout(new BorderLayout());
        JPanel header = new JPanel();
        header.setBackground(Color.black);
        header.setLayout(new BoxLayout(header, 2));
        header.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        this.add((Component)header, "First");
        JLabel title = new JLabel(this.resources.getString("launcher.installer.title", new String[0]));
        title.setFont(this.resources.getFont("Raleway+FireflySung.ttf", 26.0f));
        title.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        title.setForeground(UIConstants.COLOR_WHITE_TEXT);
        title.setOpaque(false);
        title.setIcon(this.resources.getIcon("options_cog.png"));
        header.add(title);
        header.add(Box.createHorizontalGlue());
        JButton closeButton = new JButton();
        closeButton.setIcon(this.resources.getIcon("close.png"));
        closeButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        closeButton.setContentAreaFilled(false);
        closeButton.setCursor(Cursor.getPredefinedCursor(12));
        closeButton.setFocusPainted(false);
        closeButton.addActionListener(e -> {
            if (this.mainFrame != null) {
                this.mainFrame.setVisible(true);
            }
            this.dispose();
        });
        header.add(closeButton);
        SimpleTabPane centerPanel = new SimpleTabPane();
        centerPanel.setBackground(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        centerPanel.setForeground(UIConstants.COLOR_GREY_TEXT);
        centerPanel.setSelectedBackground(UIConstants.COLOR_BLUE);
        centerPanel.setSelectedForeground(UIConstants.COLOR_WHITE_TEXT);
        centerPanel.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 14.0f));
        centerPanel.setOpaque(true);
        this.add((Component)centerPanel, "Center");
        JPanel standardInstallPanel = new JPanel();
        standardInstallPanel.setBackground(UIConstants.COLOR_CENTRAL_BACK_OPAQUE);
        this.setupStandardInstall(standardInstallPanel);
        JPanel portableModePanel = new JPanel();
        portableModePanel.setBackground(UIConstants.COLOR_CENTRAL_BACK_OPAQUE);
        this.setupPortableMode(portableModePanel);
        centerPanel.addTab(this.resources.getString("launcher.installer.standard", new String[0]).toUpperCase(), standardInstallPanel);
        centerPanel.addTab(this.resources.getString("launcher.installer.portable", new String[0]).toUpperCase(), portableModePanel);
        if (this.settings.isPortable()) {
            centerPanel.setSelectedIndex(1);
        } else {
            centerPanel.setSelectedIndex(0);
        }
        this.setLocationRelativeTo(null);
    }

    private void setupStandardInstall(JPanel panel) {
        panel.setLayout(new GridBagLayout());
        JLabel standardSpiel = new JLabel("<html><body align=\"left\" style='margin-right:10px;'>" + this.resources.getString("launcher.installer.standardspiel", new String[0]) + "</body></html>");
        standardSpiel.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        standardSpiel.setForeground(UIConstants.COLOR_WHITE_TEXT);
        standardSpiel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)standardSpiel, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 1, new Insets(9, 0, 0, 3), 0, 0));
        panel.add(Box.createGlue(), new GridBagConstraints(0, 1, 3, 1, 1.0, 0.7, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.standardDefaultDirectory = new JCheckBox(this.resources.getString("launcher.installer.default", new String[0]));
        this.standardDefaultDirectory.setOpaque(false);
        this.standardDefaultDirectory.setHorizontalAlignment(4);
        this.standardDefaultDirectory.setBorder(BorderFactory.createEmptyBorder());
        this.standardDefaultDirectory.setIconTextGap(0);
        this.standardDefaultDirectory.setSelectedIcon(this.resources.getIcon("checkbox_closed.png"));
        this.standardDefaultDirectory.setIcon(this.resources.getIcon("checkbox_open.png"));
        this.standardDefaultDirectory.setFocusPainted(false);
        this.standardDefaultDirectory.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.standardDefaultDirectory.setForeground(UIConstants.COLOR_WHITE_TEXT);
        this.standardDefaultDirectory.setIconTextGap(6);
        this.standardDefaultDirectory.setSelected(this.settings.isPortable() || this.settings.getTechnicRoot().getAbsolutePath().equals(OperatingSystem.getOperatingSystem().getTechnicDirectory().getAbsolutePath()));
        this.standardDefaultDirectory.addActionListener(e -> this.useDefaultDirectoryChanged());
        panel.add((Component)this.standardDefaultDirectory, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 12, 0), 0, 0));
        JLabel installFolderLabel = new JLabel(this.resources.getString("launcher.installer.folder", new String[0]));
        installFolderLabel.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        installFolderLabel.setForeground(UIConstants.COLOR_WHITE_TEXT);
        panel.add((Component)installFolderLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 0, 8), 0, 0));
        String installDir = OperatingSystem.getOperatingSystem().getTechnicDirectory().getAbsolutePath();
        if (!this.settings.isPortable()) {
            installDir = this.settings.getTechnicRoot().getAbsolutePath();
        }
        this.standardInstallDir = new JTextField(installDir);
        this.standardInstallDir.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.standardInstallDir.setBackground(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        this.standardInstallDir.setHighlighter(null);
        this.standardInstallDir.setEditable(false);
        this.standardInstallDir.setCursor(null);
        panel.add((Component)this.standardInstallDir, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 16));
        this.standardSelectButton = new RoundedButton(this.resources.getString("launcher.installer.select", new String[0]));
        this.standardSelectButton.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.standardSelectButton.setContentAreaFilled(false);
        this.standardSelectButton.setHoverForeground(UIConstants.COLOR_BLUE);
        this.standardSelectButton.addActionListener(e -> this.selectStandard());
        panel.add((Component)this.standardSelectButton, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 16), 0, 0));
        this.useDefaultDirectoryChanged();
        panel.add(Box.createGlue(), new GridBagConstraints(0, 4, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        String defaultLocaleText = this.resources.getString("launcheroptions.language.default", new String[0]);
        if (!this.resources.isDefaultLocaleSupported()) {
            defaultLocaleText = defaultLocaleText.concat(" (" + this.resources.getString("launcheroptions.language.unavailable", new String[0]) + ")");
        }
        this.standardLanguages = new JComboBox();
        UIUtils.populateLanguageSelector(defaultLocaleText, this.standardLanguages, this.resources, this.settings);
        this.standardLanguages.setBorder(new RoundBorder(UIConstants.COLOR_SCROLL_THUMB, 1, 10));
        this.standardLanguages.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 14.0f));
        this.standardLanguages.setUI(new LanguageCellUI(new RoundedBorderFormatter(new LineBorder(Color.black, 1)), UIConstants.COLOR_SCROLL_TRACK, UIConstants.COLOR_SCROLL_THUMB));
        this.standardLanguages.setForeground(UIConstants.COLOR_WHITE_TEXT);
        this.standardLanguages.setBackground(UIConstants.COLOR_SELECTOR_BACK);
        this.standardLanguages.setRenderer(new LanguageCellRenderer(this.resources, "globe.png", UIConstants.COLOR_SELECTOR_BACK, UIConstants.COLOR_WHITE_TEXT));
        this.standardLanguages.setEditable(false);
        this.standardLanguages.setFocusable(false);
        this.standardLanguages.addActionListener(e -> this.standardLanguageChanged());
        panel.add((Component)this.standardLanguages, new GridBagConstraints(0, 5, 1, 0, 0.0, 0.0, 16, 0, new Insets(0, 8, 8, 0), 0, 0));
        RoundedButton install = new RoundedButton(this.resources.getString("launcher.installer.install", new String[0]));
        install.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        install.setContentAreaFilled(false);
        install.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        install.setHoverForeground(UIConstants.COLOR_BLUE);
        install.setBorder(BorderFactory.createEmptyBorder(5, 17, 10, 17));
        install.addActionListener(e -> this.standardInstall());
        panel.add((Component)install, new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 8, 8), 0, 0));
    }

    private void setupPortableMode(JPanel panel) {
        panel.setLayout(new GridBagLayout());
        JLabel portableSpiel = new JLabel("<html><body align=\"left\" style='margin-right:10px;'>" + this.resources.getString("launcher.installer.portablespiel", new String[0]) + "</body></html>");
        portableSpiel.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        portableSpiel.setForeground(UIConstants.COLOR_WHITE_TEXT);
        portableSpiel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)portableSpiel, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 1, new Insets(9, 8, 9, 3), 0, 0));
        panel.add(Box.createGlue(), new GridBagConstraints(0, 1, 3, 1, 1.0, 0.7, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel installFolderLabel = new JLabel(this.resources.getString("launcher.installer.folder", new String[0]));
        installFolderLabel.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        installFolderLabel.setForeground(UIConstants.COLOR_WHITE_TEXT);
        panel.add((Component)installFolderLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 0, 8), 0, 0));
        String installDir = "";
        if (this.settings.isPortable()) {
            installDir = this.settings.getTechnicRoot().getAbsolutePath();
        }
        this.portableInstallDir = new JTextField(installDir);
        this.portableInstallDir.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.portableInstallDir.setForeground(UIConstants.COLOR_BLUE);
        this.portableInstallDir.setBackground(UIConstants.COLOR_FORM_ELEMENT_INTERNAL);
        this.portableInstallDir.setHighlighter(null);
        this.portableInstallDir.setEditable(false);
        this.portableInstallDir.setCursor(null);
        this.portableInstallDir.setBorder(new RoundBorder(UIConstants.COLOR_BUTTON_BLUE, 1, 8));
        panel.add((Component)this.portableInstallDir, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 16));
        RoundedButton selectInstall = new RoundedButton(this.resources.getString("launcher.installer.select", new String[0]));
        selectInstall.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        selectInstall.setContentAreaFilled(false);
        selectInstall.setForeground(UIConstants.COLOR_BUTTON_BLUE);
        selectInstall.setHoverForeground(UIConstants.COLOR_BLUE);
        selectInstall.addActionListener(e -> this.selectPortable());
        panel.add((Component)selectInstall, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 16), 0, 0));
        panel.add(Box.createGlue(), new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        String defaultLocaleText = this.resources.getString("launcheroptions.language.default", new String[0]);
        if (!this.resources.isDefaultLocaleSupported()) {
            defaultLocaleText = defaultLocaleText.concat(" (" + this.resources.getString("launcheroptions.language.unavailable", new String[0]) + ")");
        }
        this.portableLanguages = new JComboBox();
        UIUtils.populateLanguageSelector(defaultLocaleText, this.portableLanguages, this.resources, this.settings);
        this.portableLanguages.setBorder(new RoundBorder(UIConstants.COLOR_SCROLL_THUMB, 1, 10));
        this.portableLanguages.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 14.0f));
        this.portableLanguages.setUI(new LanguageCellUI(new RoundedBorderFormatter(new LineBorder(Color.black, 1)), UIConstants.COLOR_SCROLL_TRACK, UIConstants.COLOR_SCROLL_THUMB));
        this.portableLanguages.setForeground(UIConstants.COLOR_WHITE_TEXT);
        this.portableLanguages.setBackground(UIConstants.COLOR_SELECTOR_BACK);
        this.portableLanguages.setRenderer(new LanguageCellRenderer(this.resources, "globe.png", UIConstants.COLOR_SELECTOR_BACK, UIConstants.COLOR_WHITE_TEXT));
        this.portableLanguages.setEditable(false);
        this.portableLanguages.setFocusable(false);
        this.portableLanguages.addActionListener(e -> this.portableLanguageChanged());
        panel.add((Component)this.portableLanguages, new GridBagConstraints(0, 4, 1, 0, 0.0, 0.0, 16, 0, new Insets(0, 8, 8, 0), 0, 0));
        this.portableInstallButton = new RoundedButton(this.resources.getString("launcher.installer.install", new String[0]));
        this.portableInstallButton.setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 16.0f));
        this.portableInstallButton.setContentAreaFilled(false);
        this.portableInstallButton.setForeground(UIConstants.COLOR_GREY_TEXT);
        this.portableInstallButton.setHoverForeground(UIConstants.COLOR_BLUE);
        this.portableInstallButton.setBorder(BorderFactory.createEmptyBorder(5, 17, 10, 17));
        this.portableInstallButton.addActionListener(e -> this.portableInstall());
        this.portableInstallButton.setEnabled(false);
        if (!installDir.isEmpty()) {
            this.portableInstallButton.setForeground(UIConstants.COLOR_BUTTON_BLUE);
            this.portableInstallButton.setEnabled(true);
        }
        panel.add((Component)this.portableInstallButton, new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 8, 8), 0, 0));
    }

    @Override
    public void relocalize(ResourceLoader loader) {
        this.resources = loader;
        this.resources.registerResource(this);
        this.setIconImage(this.resources.getImage("icon.png"));
        this.getContentPane().removeAll();
        this.setLayout(null);
        this.initComponents();
        this.invalidate();
    }
}

