/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.settings.migration;

import net.technicpack.launcher.io.InstalledPackStore;
import net.technicpack.launcher.io.LauncherFileSystem;
import net.technicpack.launcher.io.UserStore;
import net.technicpack.launcher.settings.TechnicSettings;
import net.technicpack.launcher.settings.migration.IMigrator;

public class ResetJvmArgsIfDefaultString
implements IMigrator {
    @Override
    public String getMigrationVersion() {
        return "1";
    }

    @Override
    public String getMigratedVersion() {
        return "2";
    }

    @Override
    public void migrate(TechnicSettings settings, InstalledPackStore packStore, LauncherFileSystem fileSystem, UserStore users) {
        if (settings.getJavaArgs() == null) {
            return;
        }
        if (settings.getJavaArgs().equalsIgnoreCase("-XX:+UnlockExperimentalVMOptions -XX:+UseG1GC -XX:G1NewSizePercent=20 -XX:G1ReservePercent=20 -XX:MaxGCPauseMillis=50 -XX:G1HeapRegionSize=32M") || settings.getJavaArgs().equalsIgnoreCase("-XX:+UnlockExperimentalVMOptions -XX:+UseG1GC -XX:G1NewSizePercent=20 -XX:G1ReservePercent=20 -XX:MaxGCPauseMillis=50 -XX:G1HeapRegionSize=32M")) {
            settings.setJavaArgs(null);
        }
    }
}

