/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.settings.migration;

import java.io.File;
import java.util.LinkedList;
import net.technicpack.launcher.io.InstalledPackStore;
import net.technicpack.launcher.io.LauncherFileSystem;
import net.technicpack.launcher.io.UserStore;
import net.technicpack.launcher.settings.TechnicSettings;
import net.technicpack.launcher.settings.migration.IMigrator;
import net.technicpack.launchercore.modpacks.InstalledPack;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.platform.IPlatformApi;
import net.technicpack.platform.io.NewsArticle;
import net.technicpack.rest.RestfulAPIException;

public class InitialV3Migrator
implements IMigrator {
    private IPlatformApi platformApi;

    public InitialV3Migrator(IPlatformApi platformApi) {
        this.platformApi = platformApi;
    }

    @Override
    public String getMigrationVersion() {
        return "0";
    }

    @Override
    public String getMigratedVersion() {
        return "1";
    }

    @Override
    public void migrate(TechnicSettings settings, InstalledPackStore packStore, LauncherFileSystem fileSystem, UserStore users) {
        int maxNewsId = 0;
        try {
            for (NewsArticle article : this.platformApi.getNews().getArticles()) {
                int newsId = article.getId();
                if (newsId <= maxNewsId) continue;
                maxNewsId = newsId;
            }
            settings.setLatestNewsArticle(maxNewsId);
        }
        catch (RestfulAPIException restfulAPIException) {
            // empty catch block
        }
        LinkedList<ModpackModel> deletePacks = new LinkedList<ModpackModel>();
        for (String packName : packStore.getPackNames()) {
            InstalledPack pack = packStore.getInstalledPacks().get(packName);
            ModpackModel model = new ModpackModel(pack, null, packStore, fileSystem);
            File installedDirectory = model.getInstalledDirectory();
            if (installedDirectory != null && installedDirectory.exists()) continue;
            deletePacks.add(model);
        }
        for (ModpackModel deletePack : deletePacks) {
            deletePack.delete();
        }
        packStore.save();
    }
}

