/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.settings;

import com.google.gson.annotations.SerializedName;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.UUID;
import java.util.logging.Level;
import net.technicpack.launchercore.util.LaunchAction;
import net.technicpack.minecraftcore.launch.ILaunchOptions;
import net.technicpack.minecraftcore.launch.WindowType;
import net.technicpack.utilslib.Utils;
import org.jetbrains.annotations.NotNull;

public class TechnicSettings
implements ILaunchOptions {
    public static final String STABLE = "stable";
    public static final String BETA = "beta";
    public static final String DEFAULT_JAVA_ARGS = "-XX:+UnlockExperimentalVMOptions -XX:+UseG1GC -XX:G1NewSizePercent=20 -XX:G1ReservePercent=20 -XX:MaxGCPauseMillis=50 -XX:G1HeapRegionSize=32M";
    private static final String PORTABLE_MODE = "portable";
    private transient File settingsFile;
    private transient File technicRoot;
    private int memory;
    private LaunchAction launchAction = LaunchAction.HIDE;
    private String buildStream = "stable";
    private boolean showConsole = true;
    private String languageCode = "default";
    private String clientId = UUID.randomUUID().toString();
    private String directory;
    private String javaArgs;
    private String wrapperCommand;
    private int latestNewsArticle;
    private boolean launchToModpacks;
    private String javaVersion = "64bit";
    private boolean autoAcceptRequirements = false;
    @SerializedName(value="javaBitness")
    private boolean prefer64Bit = true;
    private String launcherSettingsVersion = "2";
    private WindowType windowType = WindowType.DEFAULT;
    private int windowWidth = 0;
    private int windowHeight = 0;
    private boolean enableStencilBuffer = true;
    private boolean useMojangJava = true;

    public File getFilePath() {
        return this.settingsFile;
    }

    public void setFilePath(File settingsFile) {
        this.settingsFile = settingsFile;
    }

    public File getTechnicRoot() {
        if (this.technicRoot == null || !this.technicRoot.exists()) {
            this.buildTechnicRoot();
        }
        return this.technicRoot;
    }

    public Path getTechnicRootPath() {
        return this.getTechnicRoot().toPath().toAbsolutePath();
    }

    public String getLauncherSettingsVersion() {
        return this.launcherSettingsVersion;
    }

    public void setLauncherSettingsVersion(String version) {
        this.launcherSettingsVersion = version;
    }

    public boolean isPortable() {
        return this.directory != null && this.directory.equalsIgnoreCase(PORTABLE_MODE);
    }

    public void setPortable() {
        this.directory = PORTABLE_MODE;
    }

    public void installTo(String directory) {
        this.directory = directory;
    }

    public int getMemory() {
        return this.memory;
    }

    public void setMemory(int memory) {
        this.memory = memory;
        this.save();
    }

    @NotNull
    public LaunchAction getLaunchAction() {
        if (this.launchAction == null) {
            return LaunchAction.HIDE;
        }
        return this.launchAction;
    }

    public void setLaunchAction(LaunchAction launchAction) {
        this.launchAction = launchAction;
        this.save();
    }

    public String getBuildStream() {
        return this.buildStream;
    }

    public void setBuildStream(String buildStream) {
        this.buildStream = buildStream;
        this.save();
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
        this.save();
    }

    public boolean getPrefer64Bit() {
        return this.prefer64Bit;
    }

    public void setPrefer64Bit(boolean prefer64Bit) {
        this.prefer64Bit = prefer64Bit;
        this.save();
    }

    public boolean getShowConsole() {
        return this.showConsole;
    }

    public void setShowConsole(boolean showConsole) {
        this.showConsole = showConsole;
        this.save();
    }

    public boolean getLaunchToModpacks() {
        return this.launchToModpacks;
    }

    public void setLaunchToModpacks(boolean launchToModpacks) {
        this.launchToModpacks = launchToModpacks;
        this.save();
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
        this.save();
    }

    public int getLatestNewsArticle() {
        return this.latestNewsArticle;
    }

    public void setLatestNewsArticle(int latestNewsArticle) {
        this.latestNewsArticle = latestNewsArticle;
        this.save();
    }

    public boolean shouldAutoAcceptModpackRequirements() {
        return this.autoAcceptRequirements;
    }

    public void setAutoAcceptModpackRequirements(boolean value) {
        this.autoAcceptRequirements = value;
        this.save();
    }

    @Override
    public WindowType getLaunchWindowType() {
        return this.windowType;
    }

    public void setLaunchWindowType(WindowType type) {
        this.windowType = type;
        this.save();
    }

    @Override
    public int getCustomWidth() {
        return this.windowWidth;
    }

    @Override
    public int getCustomHeight() {
        return this.windowHeight;
    }

    public void setLaunchWindowDimensions(int width, int height) {
        this.windowWidth = width;
        this.windowHeight = height;
        this.save();
    }

    @Override
    public boolean shouldUseStencilBuffer() {
        return this.enableStencilBuffer;
    }

    public void setUseStencilBuffer(boolean stencilBuffer) {
        this.enableStencilBuffer = stencilBuffer;
        this.save();
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getJavaArgs() {
        if (this.javaArgs == null || this.javaArgs.isEmpty()) {
            return DEFAULT_JAVA_ARGS;
        }
        return this.javaArgs;
    }

    public void setJavaArgs(String args) {
        this.javaArgs = args != null && args.equalsIgnoreCase(DEFAULT_JAVA_ARGS) ? null : args;
    }

    @Override
    public String getWrapperCommand() {
        return this.wrapperCommand;
    }

    public void setWrapperCommand(String wrapperCommand) {
        this.wrapperCommand = wrapperCommand;
    }

    @Override
    public boolean shouldUseMojangJava() {
        return this.useMojangJava;
    }

    public void setUseMojangJava(boolean useMojangJava) {
        this.useMojangJava = useMojangJava;
    }

    public void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(this.settingsFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            Utils.getGson().toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            Utils.getLogger().log(Level.SEVERE, String.format("Failed to save settings %s", this.settingsFile), e);
        }
    }

    protected void buildTechnicRoot() {
        this.technicRoot = this.directory == null || this.directory.isEmpty() || this.directory.equalsIgnoreCase(PORTABLE_MODE) ? this.settingsFile.getParentFile() : new File(this.directory);
        if (!this.technicRoot.exists()) {
            this.technicRoot.mkdirs();
        }
    }
}

