/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.settings;

import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import java.util.logging.Level;
import net.technicpack.launcher.io.InstalledPackStore;
import net.technicpack.launcher.io.LauncherFileSystem;
import net.technicpack.launcher.io.UserStore;
import net.technicpack.launcher.settings.TechnicSettings;
import net.technicpack.launcher.settings.migration.IMigrator;
import net.technicpack.utilslib.OperatingSystem;
import net.technicpack.utilslib.Utils;

public class SettingsFactory {
    public static TechnicSettings buildSettingsObject(String runningDir, boolean isMover) {
        System.out.println("Settings for exe: " + runningDir);
        File portableSettingsDir = SettingsFactory.getPortableSettingsDir(runningDir, isMover);
        if (portableSettingsDir == null) {
            System.out.println("Portable settings dir has broken terribly");
        } else {
            System.out.println("Portable settings dir: " + portableSettingsDir.getAbsolutePath());
        }
        TechnicSettings portableSettings = SettingsFactory.tryGetSettings(portableSettingsDir);
        if (portableSettings != null && portableSettings.isPortable()) {
            System.out.println("Portable settings file found.");
            return portableSettings;
        }
        File installedSettingsDir = OperatingSystem.getOperatingSystem().getTechnicDirectory();
        TechnicSettings settings = SettingsFactory.tryGetSettings(installedSettingsDir);
        return settings;
    }

    public static void migrateSettings(TechnicSettings settings, InstalledPackStore packStore, LauncherFileSystem fileSystem, UserStore users, List<IMigrator> migrators) {
        for (IMigrator migrator : migrators) {
            boolean bothNull;
            String version = settings.getLauncherSettingsVersion();
            boolean bl = bothNull = version == null && migrator.getMigrationVersion() == null;
            if (!bothNull && (version == null || !version.equals(migrator.getMigrationVersion()))) continue;
            migrator.migrate(settings, packStore, fileSystem, users);
            settings.setLauncherSettingsVersion(migrator.getMigratedVersion());
        }
        settings.save();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static TechnicSettings tryGetSettings(File rootDir) {
        if (!rootDir.exists()) {
            return null;
        }
        File settingsFile = new File(rootDir, "settings.json");
        if (settingsFile == null) return null;
        if (!settingsFile.exists()) {
            return null;
        }
        try (BufferedReader reader = Files.newBufferedReader(settingsFile.toPath(), StandardCharsets.UTF_8);){
            TechnicSettings settings = Utils.getGson().fromJson((Reader)reader, TechnicSettings.class);
            if (settings != null) {
                settings.setFilePath(settingsFile);
            }
            TechnicSettings technicSettings = settings;
            return technicSettings;
        }
        catch (JsonParseException | IOException e) {
            Utils.getLogger().log(Level.WARNING, "Unable to load version from " + settingsFile);
            return null;
        }
    }

    private static File getPortableSettingsDir(String runningDir, boolean isMover) {
        File runningFolder = new File(runningDir).getParentFile();
        if (isMover) {
            return runningFolder;
        }
        return new File(runningFolder, "technic");
    }
}

