/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.launch;

import io.sentry.Sentry;
import java.io.File;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.zip.ZipException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.technicpack.launcher.io.LauncherFileSystem;
import net.technicpack.launcher.launch.LauncherUnhider;
import net.technicpack.launcher.settings.StartupParameters;
import net.technicpack.launcher.settings.TechnicSettings;
import net.technicpack.launcher.ui.LauncherFrame;
import net.technicpack.launcher.ui.components.FixRunDataDialog;
import net.technicpack.launchercore.TechnicConstants;
import net.technicpack.launchercore.exception.BuildInaccessibleException;
import net.technicpack.launchercore.exception.CacheDeleteException;
import net.technicpack.launchercore.exception.DownloadException;
import net.technicpack.launchercore.exception.InstallException;
import net.technicpack.launchercore.exception.PackNotAvailableOfflineException;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.ModpackInstaller;
import net.technicpack.launchercore.install.ModpackVersion;
import net.technicpack.launchercore.install.tasks.CheckRunDataFile;
import net.technicpack.launchercore.install.tasks.TaskGroup;
import net.technicpack.launchercore.install.tasks.WriteRundataFile;
import net.technicpack.launchercore.launch.GameProcess;
import net.technicpack.launchercore.launch.java.IJavaRuntime;
import net.technicpack.launchercore.launch.java.JavaVersionRepository;
import net.technicpack.launchercore.modpacks.ModpackModel;
import net.technicpack.launchercore.modpacks.RunData;
import net.technicpack.launchercore.modpacks.resources.PackResourceMapper;
import net.technicpack.launchercore.util.DownloadListener;
import net.technicpack.launchercore.util.LaunchAction;
import net.technicpack.minecraftcore.install.tasks.CleanupAndExtractModpackTask;
import net.technicpack.minecraftcore.install.tasks.EnsureAssetsIndexTask;
import net.technicpack.minecraftcore.install.tasks.EnsureJavaRuntimeManifestTask;
import net.technicpack.minecraftcore.install.tasks.HandleVersionFileTask;
import net.technicpack.minecraftcore.install.tasks.InstallFmlLibsTask;
import net.technicpack.minecraftcore.install.tasks.InstallMinecraftIfNecessaryTask;
import net.technicpack.minecraftcore.install.tasks.RenameJnilibToDylibTask;
import net.technicpack.minecraftcore.install.tasks.VerifyVersionFilePresentTask;
import net.technicpack.minecraftcore.launch.LaunchOptions;
import net.technicpack.minecraftcore.launch.MinecraftLauncher;
import net.technicpack.minecraftcore.mojang.version.IMinecraftVersionInfo;
import net.technicpack.minecraftcore.mojang.version.MinecraftVersionInfoBuilder;
import net.technicpack.minecraftcore.mojang.version.builder.FileMinecraftVersionInfoBuilder;
import net.technicpack.minecraftcore.mojang.version.builder.MinecraftVersionInfoRetriever;
import net.technicpack.minecraftcore.mojang.version.builder.retrievers.HttpMinecraftVersionInfoRetriever;
import net.technicpack.minecraftcore.mojang.version.builder.retrievers.ZipMinecraftVersionInfoRetriever;
import net.technicpack.minecraftcore.mojang.version.chain.ChainedMinecraftVersionInfoBuilder;
import net.technicpack.rest.io.Modpack;
import net.technicpack.rest.io.PackInfo;
import net.technicpack.ui.lang.ResourceLoader;
import net.technicpack.utilslib.Memory;
import net.technicpack.utilslib.OperatingSystem;
import net.technicpack.utilslib.Utils;

public class Installer {
    protected final ModpackInstaller installer;
    protected final MinecraftLauncher launcher;
    protected final TechnicSettings settings;
    protected final PackResourceMapper packIconMapper;
    protected final StartupParameters startupParameters;
    protected final LauncherFileSystem fileSystem;
    protected volatile boolean isCancelledByUser = false;
    private Thread installerThread;
    private GameProcess gameProcess;
    private final Object gameLock = new Object();

    public Installer(StartupParameters startupParameters, LauncherFileSystem fileSystem, ModpackInstaller installer, MinecraftLauncher launcher, TechnicSettings settings, PackResourceMapper packIconMapper) {
        this.installer = installer;
        this.launcher = launcher;
        this.settings = settings;
        this.packIconMapper = packIconMapper;
        this.startupParameters = startupParameters;
        this.fileSystem = fileSystem;
    }

    public void cancel() {
        Utils.getLogger().info("User pressed cancel button.");
        this.isCancelledByUser = true;
        this.installerThread.interrupt();
    }

    public void justInstall(ResourceLoader resources, ModpackModel pack, String build, boolean doFullInstall, LauncherFrame frame, DownloadListener listener) {
        this.internalInstallAndRun(resources, pack, build, doFullInstall, frame, listener, false);
    }

    public void installAndRun(ResourceLoader resources, ModpackModel pack, String build, boolean doFullInstall, LauncherFrame frame, DownloadListener listener) {
        this.internalInstallAndRun(resources, pack, build, doFullInstall, frame, listener, true);
    }

    protected void internalInstallAndRun(ResourceLoader resources, ModpackModel pack, String build, boolean doFullInstall, LauncherFrame frame, DownloadListener listener, boolean doLaunch) {
        if (this.isCurrentlyRunning()) {
            Utils.getLogger().warning("Installer is already running, ignoring install request.");
            return;
        }
        this.isCancelledByUser = false;
        this.installerThread = new InstallerThread(listener, pack, build, resources, doFullInstall, doLaunch, frame);
        this.installerThread.start();
    }

    public boolean isCurrentlyRunning() {
        return this.installerThread != null && this.installerThread.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGameProcessRunning() {
        Object object = this.gameLock;
        synchronized (object) {
            return this.gameProcess != null && this.gameProcess.getProcess() != null && this.gameProcess.getProcess().isAlive();
        }
    }

    private class InstallerThread
    extends Thread {
        private final DownloadListener listener;
        private final ModpackModel pack;
        private final String build;
        private final ResourceLoader resources;
        private final boolean doFullInstall;
        private final boolean doLaunch;
        private final LauncherFrame frame;

        public InstallerThread(DownloadListener listener, ModpackModel pack, String build, ResourceLoader resources, boolean doFullInstall, boolean doLaunch, LauncherFrame frame) {
            super("InstallerThread");
            this.setDaemon(true);
            this.listener = listener;
            this.pack = pack;
            this.build = build;
            this.resources = resources;
            this.doFullInstall = doFullInstall;
            this.doLaunch = doLaunch;
            this.frame = frame;
            Utils.getLogger().info(String.format("Starting installer thread for %s (%s)", pack.getDisplayName(), build));
            Sentry.addBreadcrumb(String.format("Starting installer thread for %s (%s)", pack.getDisplayName(), build));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            this.setGameProcess(null);
            try {
                int result;
                InstallTasksQueue<IMinecraftVersionInfo> tasksQueue = new InstallTasksQueue<IMinecraftVersionInfo>(this.listener);
                MinecraftVersionInfoBuilder versionBuilder = this.createVersionBuilder(tasksQueue);
                JavaVersionRepository javaVersions = Installer.this.launcher.getJavaVersions();
                boolean mojangJavaWanted = Installer.this.settings.shouldUseMojangJava();
                this.buildTasksQueue(tasksQueue, this.build, versionBuilder, javaVersions.getSelectedVersion(), mojangJavaWanted);
                IMinecraftVersionInfo version = Installer.this.installer.installPack(tasksQueue, this.pack, this.build);
                if (!this.doLaunch) return;
                if (version == null) {
                    throw new PackNotAvailableOfflineException(this.pack.getDisplayName());
                }
                boolean usingMojangJava = mojangJavaWanted && version.getMojangRuntimeInformation() != null;
                Memory memoryObj = Memory.getClosestAvailableMemory(Memory.getMemoryFromId(Installer.this.settings.getMemory()), javaVersions.getSelectedVersion().is64Bit());
                long memory = memoryObj.getMemoryMB();
                String versionNumber = javaVersions.getSelectedVersion().getVersion();
                RunData data = this.pack.getRunData();
                if (data != null && !data.isRunDataValid(memory, versionNumber, usingMojangJava)) {
                    FixRunDataDialog dialog = new FixRunDataDialog(this.frame, this.resources, data, javaVersions, memoryObj, !Installer.this.settings.shouldAutoAcceptModpackRequirements(), usingMojangJava);
                    dialog.setVisible(true);
                    if (dialog.getResult() != FixRunDataDialog.Result.APPLY) return;
                    memoryObj = dialog.getRecommendedMemory();
                    memory = memoryObj.getMemoryMB();
                    Installer.this.settings.setMemory(memoryObj.getSettingsId());
                    IJavaRuntime recommendedJavaVersion = dialog.getRecommendedJavaVersion();
                    if (recommendedJavaVersion != null) {
                        javaVersions.selectVersion(recommendedJavaVersion.getVersion(), recommendedJavaVersion.is64Bit());
                        Installer.this.settings.setJavaVersion(recommendedJavaVersion.getVersion());
                        Installer.this.settings.setPrefer64Bit(recommendedJavaVersion.is64Bit());
                    }
                    if (dialog.shouldRemember()) {
                        Installer.this.settings.setAutoAcceptModpackRequirements(true);
                    }
                }
                if (!usingMojangJava && RunData.isJavaVersionAtLeast(versionNumber, "1.9") && (result = JOptionPane.showConfirmDialog(this.frame, this.resources.getString("launcher.jverwarning", versionNumber), this.resources.getString("launcher.jverwarning.title", new String[0]), 0, 2)) != 0) {
                    return;
                }
                LaunchAction launchAction = Installer.this.settings.getLaunchAction();
                LauncherUnhider launcherUnhider = launchAction == LaunchAction.HIDE ? new LauncherUnhider(Installer.this.settings, this.frame) : null;
                LaunchOptions options = new LaunchOptions(this.pack.getDisplayName(), Installer.this.packIconMapper.getImageLocation(this.pack).getAbsolutePath(), Installer.this.settings);
                this.setGameProcess(Installer.this.launcher.launch(this.pack, memory, options, launcherUnhider, version));
                switch (launchAction) {
                    case HIDE: {
                        this.frame.setVisible(false);
                        return;
                    }
                    case NOTHING: {
                        SwingUtilities.invokeLater(this.frame::launchCompleted);
                        return;
                    }
                    case CLOSE: {
                        System.exit(0);
                        return;
                    }
                }
                return;
            }
            catch (InterruptedException | ClosedByInterruptException e) {
                if (Installer.this.isCancelledByUser) {
                    Utils.getLogger().info("Cancelled by user.");
                } else {
                    if (e.getCause() != null) {
                        Utils.getLogger().log(Level.INFO, "Cancelled by exception.", e);
                    } else {
                        Utils.getLogger().log(Level.INFO, "Cancelled by code.");
                    }
                    Sentry.captureException(e);
                }
                this.interrupt();
                return;
            }
            catch (PackNotAvailableOfflineException e) {
                this.showErrorDialog(this.resources.getString("launcher.installerror.unavailable", new String[0]), e.getMessage());
                return;
            }
            catch (DownloadException e) {
                this.showErrorDialog(this.resources.getString("launcher.installerror.download", this.pack.getDisplayName(), e.getMessage()));
                return;
            }
            catch (ZipException e) {
                this.showErrorDialog(this.resources.getString("launcher.installerror.unzip", this.pack.getDisplayName(), e.getMessage()));
                return;
            }
            catch (CacheDeleteException e) {
                this.showErrorDialog(this.resources.getString("launcher.installerror.cache", this.pack.getDisplayName(), e.getMessage()));
                return;
            }
            catch (BuildInaccessibleException | InstallException e) {
                Utils.getLogger().log(Level.SEVERE, "Exception caught during modpack installation or launch.", e);
                this.showErrorDialog(e.getMessage());
                return;
            }
            catch (Exception e) {
                Utils.getLogger().log(Level.SEVERE, "Exception caught during modpack installation or launch.", e);
                Sentry.captureException(e);
                this.showErrorDialog(String.format("Unknown error: %s", e.getMessage()));
                return;
            }
            finally {
                block37: {
                    block36: {
                        if (!this.doLaunch) break block36;
                        if (Installer.this.isGameProcessRunning()) break block37;
                    }
                    SwingUtilities.invokeLater(this.frame::launchCompleted);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setGameProcess(GameProcess gameProcess) {
            Object object = Installer.this.gameLock;
            synchronized (object) {
                Installer.this.gameProcess = gameProcess;
            }
        }

        private void showErrorDialog(String title, String message) {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.frame, message, title, 0));
        }

        private void showErrorDialog(String message) {
            this.showErrorDialog(this.resources.getString("launcher.installerror.title", new String[0]), message);
        }

        private void buildTasksQueue(InstallTasksQueue<IMinecraftVersionInfo> queue, String build, MinecraftVersionInfoBuilder versionBuilder, IJavaRuntime selectedJavaRuntime, boolean mojangJavaWanted) throws IOException, InstallException {
            PackInfo packInfo = this.pack.getPackInfo();
            if (packInfo == null) {
                throw new InstallException("No modpack information found, cannot install or launch modpack.");
            }
            Modpack modpackData = packInfo.getModpack(build);
            if (modpackData.getGameVersion() == null) {
                throw new InstallException("No game version found for modpack, cannot install or launch modpack.");
            }
            String minecraft = modpackData.getGameVersion();
            ModpackVersion installedVersion = this.pack.getInstalledVersion();
            TaskGroup<IMinecraftVersionInfo> examineModpackData = new TaskGroup<IMinecraftVersionInfo>(this.resources.getString("install.message.examiningmodpack", new String[0]));
            TaskGroup<IMinecraftVersionInfo> verifyingFiles = new TaskGroup<IMinecraftVersionInfo>(this.resources.getString("install.message.verifyingfiles", new String[0]));
            TaskGroup<IMinecraftVersionInfo> downloadingMods = new TaskGroup<IMinecraftVersionInfo>(this.resources.getString("install.message.downloadmods", new String[0]));
            TaskGroup<IMinecraftVersionInfo> installingMods = new TaskGroup<IMinecraftVersionInfo>(this.resources.getString("install.message.installmods", new String[0]));
            TaskGroup<IMinecraftVersionInfo> checkVersionFile = new TaskGroup<IMinecraftVersionInfo>(this.resources.getString("install.message.checkversionfile", new String[0]));
            TaskGroup installVersionFile = new TaskGroup(this.resources.getString("install.message.installversionfile", new String[0]));
            TaskGroup<IMinecraftVersionInfo> rundataTaskGroup = new TaskGroup<IMinecraftVersionInfo>(this.resources.getString("install.message.runData", new String[0]));
            TaskGroup<IMinecraftVersionInfo> examineVersionFile = new TaskGroup<IMinecraftVersionInfo>(this.resources.getString("install.message.examiningversionfile", new String[0]));
            TaskGroup<IMinecraftVersionInfo> grabLibs = new TaskGroup<IMinecraftVersionInfo>(this.resources.getString("install.message.grablibraries", new String[0]));
            TaskGroup<IMinecraftVersionInfo> checkNonMavenLibs = new TaskGroup<IMinecraftVersionInfo>(this.resources.getString("install.message.nonmavenlibs", new String[0]));
            TaskGroup<IMinecraftVersionInfo> installingLibs = new TaskGroup<IMinecraftVersionInfo>(this.resources.getString("install.message.installlibs", new String[0]));
            TaskGroup<IMinecraftVersionInfo> installingMinecraft = new TaskGroup<IMinecraftVersionInfo>(this.resources.getString("install.message.installminecraft", new String[0]));
            TaskGroup<IMinecraftVersionInfo> examineIndex = new TaskGroup<IMinecraftVersionInfo>(this.resources.getString("install.message.examiningindex", new String[0]));
            TaskGroup<IMinecraftVersionInfo> verifyingAssets = new TaskGroup<IMinecraftVersionInfo>(this.resources.getString("install.message.verifyassets", new String[0]));
            TaskGroup<IMinecraftVersionInfo> installingAssets = new TaskGroup<IMinecraftVersionInfo>(this.resources.getString("install.message.installassets", new String[0]));
            TaskGroup<IMinecraftVersionInfo> fetchJavaManifest = new TaskGroup<IMinecraftVersionInfo>("Obtaining Java runtime information...");
            TaskGroup<IMinecraftVersionInfo> examineJava = new TaskGroup<IMinecraftVersionInfo>("Examining Java runtime...");
            TaskGroup<IMinecraftVersionInfo> downloadJava = new TaskGroup<IMinecraftVersionInfo>("Downloading Java runtime...");
            queue.addTask(examineModpackData);
            queue.addTask(verifyingFiles);
            queue.addTask(downloadingMods);
            queue.addTask(installingMods);
            queue.addTask(checkVersionFile);
            queue.addTask(installVersionFile);
            queue.addTask(rundataTaskGroup);
            queue.addTask(examineVersionFile);
            queue.addTask(grabLibs);
            queue.addTask(checkNonMavenLibs);
            queue.addTask(installingLibs);
            queue.addTask(installingMinecraft);
            queue.addTask(examineIndex);
            queue.addTask(verifyingAssets);
            queue.addTask(installingAssets);
            if (mojangJavaWanted) {
                queue.addTask(fetchJavaManifest);
                queue.addTask(examineJava);
                queue.addTask(downloadJava);
            }
            if (OperatingSystem.getOperatingSystem() == OperatingSystem.OSX) {
                queue.addTask(new RenameJnilibToDylibTask(this.pack));
            }
            if (this.doFullInstall) {
                examineModpackData.addTask(new CleanupAndExtractModpackTask(this.pack, modpackData, verifyingFiles, downloadingMods, installingMods));
                rundataTaskGroup.addTask(new WriteRundataFile(this.pack, modpackData));
            } else {
                rundataTaskGroup.addTask(new CheckRunDataFile(this.pack, modpackData, rundataTaskGroup));
            }
            verifyingFiles.addTask(new InstallFmlLibsTask(this.pack, Installer.this.fileSystem, modpackData, verifyingFiles, installingLibs, installingLibs));
            checkVersionFile.addTask(new VerifyVersionFilePresentTask(this.pack, minecraft, versionBuilder));
            examineVersionFile.addTask(new HandleVersionFileTask().withPack(this.pack).withFileSystem(Installer.this.fileSystem).withCheckNonMavenLibsQueue(checkNonMavenLibs).withCheckLibraryQueue(grabLibs).withDownloadLibraryQueue(installingLibs).withCopyLibraryQueue(installingLibs).withVersionBuilder(versionBuilder).withLaunchOptions(Installer.this.settings).withJavaRuntime(selectedJavaRuntime));
            examineVersionFile.addTask(new EnsureAssetsIndexTask(Installer.this.fileSystem.getAssetsDirectory().toFile(), this.pack, installingMinecraft, examineIndex, verifyingAssets, installingAssets, installingAssets));
            fetchJavaManifest.addTask(new EnsureJavaRuntimeManifestTask(Installer.this.fileSystem.getRuntimesDirectory(), this.pack, fetchJavaManifest, examineJava, downloadJava));
            boolean jarRegenerationRequired = this.doFullInstall || installedVersion != null && installedVersion.isLegacy();
            installingMinecraft.addTask(new InstallMinecraftIfNecessaryTask(this.pack, minecraft, Installer.this.fileSystem.getCacheDirectory(), jarRegenerationRequired));
        }

        private MinecraftVersionInfoBuilder createVersionBuilder(InstallTasksQueue<IMinecraftVersionInfo> tasksQueue) {
            ZipMinecraftVersionInfoRetriever zipVersionRetriever = new ZipMinecraftVersionInfoRetriever(new File(this.pack.getBinDir(), "modpack.jar"));
            HttpMinecraftVersionInfoRetriever fallbackVersionRetriever = new HttpMinecraftVersionInfoRetriever(TechnicConstants.VERSIONS_BASE_URL, tasksQueue.getDownloadListener());
            ArrayList<MinecraftVersionInfoRetriever> fallbackRetrievers = new ArrayList<MinecraftVersionInfoRetriever>(1);
            fallbackRetrievers.add(fallbackVersionRetriever);
            File versionJson = new File(this.pack.getBinDir(), "version.json");
            FileMinecraftVersionInfoBuilder zipVersionBuilder = new FileMinecraftVersionInfoBuilder(versionJson, zipVersionRetriever, fallbackRetrievers);
            FileMinecraftVersionInfoBuilder webVersionBuilder = new FileMinecraftVersionInfoBuilder(this.pack.getBinDir(), null, fallbackRetrievers);
            return new ChainedMinecraftVersionInfoBuilder(zipVersionBuilder, webVersionBuilder);
        }
    }
}

