/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.io;

import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.technicpack.launchercore.auth.IUserType;
import net.technicpack.minecraftcore.MojangUtils;
import net.technicpack.utilslib.Utils;

public class UserStore {
    private Map<String, IUserType> savedUsers = new HashMap<String, IUserType>();
    private String lastUser;
    private transient Path storePath;

    private UserStore() {
    }

    private UserStore(Path storePath) {
        this.storePath = storePath.toAbsolutePath();
    }

    public static UserStore load(Path storePath) {
        if (!Files.exists(storePath, new LinkOption[0])) {
            Utils.getLogger().log(Level.WARNING, String.format("Unable to load users from %s because it does not exist", storePath));
            return new UserStore(storePath);
        }
        try {
            UserStore newModel;
            try (BufferedReader reader = Files.newBufferedReader(storePath, StandardCharsets.UTF_8);){
                newModel = MojangUtils.getGson().fromJson((Reader)reader, UserStore.class);
            }
            if (newModel != null) {
                newModel.removeNullUsers();
                newModel.setStorePath(storePath);
                return newModel;
            }
        }
        catch (JsonParseException | IOException e) {
            Utils.getLogger().log(Level.SEVERE, String.format("Failed to load users from %s", storePath), e);
        }
        return new UserStore(storePath);
    }

    private void setStorePath(Path storePath) {
        this.storePath = storePath;
    }

    public void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(this.storePath, StandardCharsets.UTF_8, new OpenOption[0]);){
            MojangUtils.getGson().toJson((Object)this, (Appendable)writer);
        }
        catch (JsonIOException | IOException e) {
            Utils.getLogger().log(Level.SEVERE, String.format("Failed to save users to %s", this.storePath), e);
        }
    }

    public void addUser(IUserType user) {
        this.savedUsers.put(user.getUsername(), user);
        this.save();
    }

    public void removeUser(String username) {
        this.savedUsers.remove(username);
        this.save();
    }

    public IUserType getUser(String accountName) {
        return this.savedUsers.get(accountName);
    }

    public Collection<String> getUsers() {
        return this.savedUsers.keySet();
    }

    public Collection<IUserType> getSavedUsers() {
        return this.savedUsers.values();
    }

    public void setLastUser(String lastUser) {
        this.lastUser = lastUser;
        this.save();
    }

    public String getLastUser() {
        return this.lastUser;
    }

    private void removeNullUsers() {
        this.savedUsers.values().removeAll(Collections.singleton(null));
    }
}

