/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.io;

import java.awt.image.BufferedImage;
import java.io.File;
import net.technicpack.launcher.io.LauncherFileSystem;
import net.technicpack.launchercore.image.IImageMapper;
import net.technicpack.platform.io.AuthorshipInfo;
import net.technicpack.ui.lang.ResourceLoader;

public class TechnicAvatarMapper
implements IImageMapper<AuthorshipInfo> {
    private LauncherFileSystem fileSystem;
    private BufferedImage defaultImage;

    public TechnicAvatarMapper(LauncherFileSystem fileSystem, ResourceLoader resources) {
        this.fileSystem = fileSystem;
        this.defaultImage = resources.getImage("icon.png");
    }

    @Override
    public boolean shouldDownloadImage(AuthorshipInfo imageKey) {
        return true;
    }

    @Override
    public File getImageLocation(AuthorshipInfo imageKey) {
        return this.fileSystem.getAssetsDirectory().resolve("avatars").resolve("gravitar").resolve(imageKey.getUser() + ".png").toFile();
    }

    @Override
    public BufferedImage getDefaultImage() {
        return this.defaultImage;
    }
}

