/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.swing.JOptionPane;

public class LauncherFileSystem {
    private final Path rootDirectory;
    private final Path assetsDirectory;
    private final Path cacheDirectory;
    private final Path logsDirectory;
    private final Path modpacksDirectory;
    private final Path runtimesDirectory;
    private final Path launcherAssetsDirectory;
    private final Path packAssetsDirectory;

    public LauncherFileSystem(Path rootDir) {
        this.rootDirectory = rootDir.toAbsolutePath().normalize();
        this.assetsDirectory = this.rootDirectory.resolve("assets");
        this.cacheDirectory = this.rootDirectory.resolve("cache");
        this.logsDirectory = this.rootDirectory.resolve("logs");
        this.modpacksDirectory = this.rootDirectory.resolve("modpacks");
        this.runtimesDirectory = this.rootDirectory.resolve("runtimes");
        this.launcherAssetsDirectory = this.assetsDirectory.resolve("launcher");
        this.packAssetsDirectory = this.assetsDirectory.resolve("packs");
        this.createDirectories();
    }

    public void createDirectories() {
        this.createDirectory(this.rootDirectory);
        this.createDirectory(this.assetsDirectory);
        this.createDirectory(this.cacheDirectory);
        this.createDirectory(this.logsDirectory);
        this.createDirectory(this.modpacksDirectory);
        this.createDirectory(this.runtimesDirectory);
        this.createDirectory(this.launcherAssetsDirectory);
        this.createDirectory(this.packAssetsDirectory);
    }

    private void createDirectory(Path path) {
        this.ensureDirectory(path);
    }

    private Path ensureDirectory(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                return path;
            }
            try {
                Files.deleteIfExists(path);
            }
            catch (IOException e) {
                LauncherFileSystem.abortWithErrorDialog(path);
            }
        }
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            LauncherFileSystem.abortWithErrorDialog(path);
        }
        return path;
    }

    private static void abortWithErrorDialog(Path path) {
        JOptionPane.showMessageDialog(null, String.format("Failed to create directory %s.%nThis is a critical error, the launcher will terminate now.", path), "Critical error - Technic Launcher", 0);
        System.exit(1);
    }

    public Path getRootDirectory() {
        return this.ensureDirectory(this.rootDirectory);
    }

    public Path getCacheDirectory() {
        return this.ensureDirectory(this.cacheDirectory);
    }

    public Path getAssetsDirectory() {
        return this.assetsDirectory;
    }

    public Path getModpacksDirectory() {
        return this.ensureDirectory(this.modpacksDirectory);
    }

    public Path getRuntimesDirectory() {
        return this.ensureDirectory(this.runtimesDirectory);
    }

    public Path getLogsDirectory() {
        return this.ensureDirectory(this.logsDirectory);
    }

    public Path getLauncherAssetsDirectory() {
        return this.ensureDirectory(this.launcherAssetsDirectory);
    }

    public Path getPackAssetsDirectory() {
        return this.ensureDirectory(this.packAssetsDirectory);
    }
}

