/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.io;

import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.technicpack.launchercore.modpacks.InstalledPack;
import net.technicpack.utilslib.Utils;

public class InstalledPackStore {
    private transient Path storePath;
    private Map<String, InstalledPack> installedPacks = new HashMap<String, InstalledPack>();
    private List<String> byIndex = new ArrayList<String>();
    private String selected = null;

    public InstalledPackStore(Path storePath) {
        this.setStorePath(storePath);
    }

    private InstalledPackStore() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InstalledPackStore load(Path storePath) {
        if (!Files.exists(storePath, new LinkOption[0])) {
            Utils.getLogger().log(Level.WARNING, String.format("Unable to load installedPacks from %s because it does not exist", storePath));
            return new InstalledPackStore(storePath);
        }
        try (BufferedReader reader = Files.newBufferedReader(storePath, StandardCharsets.UTF_8);){
            InstalledPackStore parsedList = Utils.getGson().fromJson((Reader)reader, InstalledPackStore.class);
            if (parsedList == null) {
                InstalledPackStore installedPackStore2 = new InstalledPackStore(storePath);
                return installedPackStore2;
            }
            parsedList.setStorePath(storePath);
            InstalledPackStore installedPackStore = parsedList;
            return installedPackStore;
        }
        catch (JsonParseException | IOException e) {
            Utils.getLogger().log(Level.SEVERE, String.format("Failed to load installedPacks from %s", storePath), e);
            return new InstalledPackStore(storePath);
        }
    }

    protected void cleanUpLegacyEntries() {
        this.installedPacks.remove("addpack");
        this.byIndex.remove("addpack");
    }

    protected void setStorePath(Path storePath) {
        this.storePath = storePath;
        this.cleanUpLegacyEntries();
    }

    public Map<String, InstalledPack> getInstalledPacks() {
        return this.installedPacks;
    }

    public List<String> getPackNames() {
        return this.byIndex;
    }

    public String getSelectedSlug() {
        return this.selected;
    }

    public void setSelectedSlug(String slug) {
        this.selected = slug;
        this.save();
    }

    public InstalledPack put(InstalledPack installedPack) {
        InstalledPack pack = this.installedPacks.put(installedPack.getName(), installedPack);
        if (pack == null) {
            this.byIndex.add(installedPack.getName());
        }
        this.save();
        return pack;
    }

    public InstalledPack remove(String name) {
        InstalledPack pack = this.installedPacks.remove(name);
        if (pack != null) {
            this.byIndex.remove(name);
        }
        this.save();
        return pack;
    }

    public void save() {
        Path tmp = this.storePath.resolveSibling(this.storePath.getFileName() + ".tmp");
        try (BufferedWriter writer = Files.newBufferedWriter(tmp, StandardCharsets.UTF_8, new OpenOption[0]);){
            Utils.getGson().toJson((Object)this, (Appendable)writer);
            Files.move(tmp, this.storePath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (JsonIOException | IOException e) {
            try {
                Files.deleteIfExists(tmp);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Utils.getLogger().log(Level.SEVERE, String.format("Failed to save installedPacks to %s", this.storePath), e);
        }
    }
}

