/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.launcher.io;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Locale;
import net.technicpack.launchercore.auth.IUserType;
import net.technicpack.minecraftcore.microsoft.auth.MicrosoftUser;
import net.technicpack.utilslib.Utils;

public class IUserTypeInstanceCreator
implements JsonDeserializer<IUserType>,
JsonSerializer<IUserType> {
    private static final String USER_TYPE_FIELD = "userType";
    private static final String BETA_MSA_USER_TYPE = "microsoft";

    @Override
    public IUserType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String userString;
        Utils.getLogger().info("User deserialization");
        JsonObject rootObject = json.getAsJsonObject();
        String string = userString = rootObject.has(USER_TYPE_FIELD) ? rootObject.get(USER_TYPE_FIELD).getAsString().toLowerCase(Locale.ROOT) : null;
        if (userString == null || userString.isEmpty()) {
            return null;
        }
        switch (userString) {
            case "msa": 
            case "microsoft": {
                Utils.getLogger().info("Deserializing microsoft user");
                return (IUserType)context.deserialize(rootObject, (Type)((Object)MicrosoftUser.class));
            }
        }
        Utils.getLogger().info(String.format("Unknown user type: %s", userString));
        return null;
    }

    @Override
    public JsonElement serialize(IUserType src, Type typeOfSrc, JsonSerializationContext context) {
        if (src instanceof MicrosoftUser) {
            JsonObject obj = context.serialize(src, (Type)((Object)MicrosoftUser.class)).getAsJsonObject();
            obj.addProperty(USER_TYPE_FIELD, "msa");
            return obj;
        }
        return null;
    }
}

