/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.discord;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import net.technicpack.discord.IDiscordApi;
import net.technicpack.discord.IDiscordCallback;
import net.technicpack.discord.io.Server;
import net.technicpack.launchercore.modpacks.ModpackModel;

public class CachedDiscordApi
implements IDiscordApi {
    private final IDiscordApi innerApi;
    private final Cache<String, Server> cache;
    private final Cache<String, Boolean> deadCache;

    public CachedDiscordApi(IDiscordApi innerApi, int cacheLength, int deadCacheLength) {
        this.innerApi = innerApi;
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(300L).expireAfterWrite(cacheLength, TimeUnit.SECONDS).build();
        this.deadCache = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(300L).expireAfterWrite(deadCacheLength, TimeUnit.SECONDS).build();
    }

    @Override
    public void retrieveServer(ModpackModel modpack, String serverId, IDiscordCallback callback) {
        Boolean deadCacheValue = this.deadCache.getIfPresent(serverId);
        if (Boolean.TRUE.equals(deadCacheValue)) {
            return;
        }
        Server cacheValue = this.cache.getIfPresent(serverId);
        if (cacheValue != null) {
            if (deadCacheValue == null) {
                this.deadCache.put(serverId, false);
            }
            callback.discordCallback(modpack, cacheValue);
            return;
        }
        this.deadCache.put(serverId, true);
        this.innerApi.retrieveServer(modpack, serverId, (pack, server) -> {
            if (server == null) {
                this.deadCache.put(serverId, true);
            } else {
                this.deadCache.put(serverId, false);
                this.cache.put(serverId, server);
            }
            callback.discordCallback(pack, server);
        });
    }
}

