/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.autoupdate.tasks;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import net.technicpack.autoupdate.IUpdateStream;
import net.technicpack.autoupdate.Relauncher;
import net.technicpack.autoupdate.io.LauncherResource;
import net.technicpack.autoupdate.io.StreamVersion;
import net.technicpack.autoupdate.tasks.DownloadUpdate;
import net.technicpack.launcher.io.LauncherFileSystem;
import net.technicpack.launchercore.exception.DownloadException;
import net.technicpack.launchercore.install.ITasksQueue;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.tasks.DownloadFileTask;
import net.technicpack.launchercore.install.tasks.IInstallTask;
import net.technicpack.launchercore.install.verifiers.IFileVerifier;
import net.technicpack.launchercore.install.verifiers.MD5FileVerifier;
import net.technicpack.launchercore.install.verifiers.SHA256FileVerifier;
import net.technicpack.rest.RestfulAPIException;
import net.technicpack.utilslib.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QueryUpdateStream
implements IInstallTask<Void> {
    private final String description;
    private final ITasksQueue<Void> downloadTasks;
    private final IUpdateStream updateStream;
    private final LauncherFileSystem fileSystem;
    private final Relauncher relauncher;
    private final Collection<IInstallTask<Void>> postDownloadTasks;

    public QueryUpdateStream(String description, IUpdateStream stream, ITasksQueue<Void> downloadTasks, LauncherFileSystem fileSystem, Relauncher relauncher, Collection<IInstallTask<Void>> postDownloadTasks) {
        this.description = description;
        this.downloadTasks = downloadTasks;
        this.updateStream = stream;
        this.fileSystem = fileSystem;
        this.relauncher = relauncher;
        this.postDownloadTasks = postDownloadTasks;
    }

    @Override
    public String getTaskDescription() {
        return this.description;
    }

    @Override
    public float getTaskProgress() {
        return 0.0f;
    }

    @Override
    public void runTask(InstallTasksQueue<Void> queue) throws IOException {
        StreamVersion version;
        try {
            version = this.updateStream.getStreamVersion(this.relauncher.getStreamName());
            if (version == null || version.getBuild() == 0) {
                return;
            }
        }
        catch (RestfulAPIException e) {
            Utils.getLogger().log(Level.SEVERE, "Failed to query update stream", e);
            return;
        }
        for (LauncherResource resource : version.getResources()) {
            IFileVerifier verifier = QueryUpdateStream.createFileVerifier(resource);
            File targetFile = this.fileSystem.getLauncherAssetsDirectory().resolve(resource.getFilename()).toFile();
            if (targetFile.exists() && verifier != null && verifier.isFileValid(targetFile)) continue;
            this.downloadTasks.addTask(QueryUpdateStream.createDownloadTask(resource, targetFile, verifier));
        }
        if (this.relauncher.isSkipUpdate() || version.getBuild() == this.relauncher.getCurrentBuild()) {
            return;
        }
        String runningPath = this.relauncher.getRunningPath();
        if (runningPath == null) {
            throw new DownloadException("Could not load a running path for currently-executing launcher.");
        }
        String updateUrl = runningPath.endsWith(".exe") ? version.getExeUrl() : version.getJarUrl();
        this.downloadTasks.addTask(new DownloadUpdate(updateUrl, this.relauncher, this.postDownloadTasks));
    }

    @Nullable
    private static IFileVerifier createFileVerifier(LauncherResource resource) {
        IFileVerifier verifier = resource.getSha256() != null && !resource.getSha256().isEmpty() ? new SHA256FileVerifier(resource.getSha256()) : (resource.getMd5() != null && !resource.getMd5().isEmpty() ? new MD5FileVerifier(resource.getMd5()) : null);
        return verifier;
    }

    @NotNull
    private static DownloadFileTask<Void> createDownloadTask(LauncherResource resource, File targetFile, IFileVerifier verifier) throws DownloadException {
        DownloadFileTask<Void> downloadFileTask;
        String zstdUrl = resource.getZstdUrl();
        if (zstdUrl != null && !zstdUrl.isEmpty()) {
            downloadFileTask = new DownloadFileTask(zstdUrl, targetFile, verifier, resource.getFilename());
            downloadFileTask.setDecompressor("zstd");
        } else {
            downloadFileTask = new DownloadFileTask<Void>(resource.getUrl(), targetFile, verifier, resource.getFilename());
        }
        return downloadFileTask;
    }
}

