/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.autoupdate;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import net.technicpack.autoupdate.IUpdateStream;
import net.technicpack.autoupdate.tasks.CopyLauncherPackage;
import net.technicpack.autoupdate.tasks.LaunchLauncherMode;
import net.technicpack.autoupdate.tasks.LaunchMoverMode;
import net.technicpack.autoupdate.tasks.QueryUpdateStream;
import net.technicpack.launcher.LauncherMain;
import net.technicpack.launcher.io.LauncherFileSystem;
import net.technicpack.launcher.settings.StartupParameters;
import net.technicpack.launcher.ui.UIConstants;
import net.technicpack.launchercore.install.InstallTasksQueue;
import net.technicpack.launchercore.install.tasks.IInstallTask;
import net.technicpack.launchercore.install.tasks.TaskGroup;
import net.technicpack.ui.controls.installation.SplashScreen;
import net.technicpack.ui.lang.ResourceLoader;
import net.technicpack.utilslib.OperatingSystem;
import net.technicpack.utilslib.ProcessUtils;
import net.technicpack.utilslib.Utils;

public class Relauncher {
    private final String stream;
    private final int currentBuild;
    private final LauncherFileSystem fileSystem;
    protected ResourceLoader resources;
    protected StartupParameters parameters;
    protected IUpdateStream updateStream;
    private boolean didUpdate = false;
    private SplashScreen screen = null;

    public Relauncher(IUpdateStream updateStream, String stream, int currentBuild, LauncherFileSystem fileSystem, ResourceLoader resources, StartupParameters parameters) {
        this.stream = stream;
        this.currentBuild = currentBuild;
        this.fileSystem = fileSystem;
        this.resources = resources;
        this.parameters = parameters;
        this.updateStream = updateStream;
    }

    public int getCurrentBuild() {
        return this.currentBuild;
    }

    public String getStreamName() {
        return this.stream;
    }

    public void setUpdated() {
        this.didUpdate = true;
    }

    protected LauncherFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public String getRunningPath() {
        return Relauncher.getRunningPath(this.getMainClass());
    }

    public static String getRunningPath(Class<?> clazz) {
        try {
            URI uri = clazz.getProtectionDomain().getCodeSource().getLocation().toURI();
            return Paths.get(uri).toString();
        }
        catch (URISyntaxException e) {
            System.err.println("Failed to get running path for class: " + clazz.getName());
            e.printStackTrace();
            System.exit(255);
            return null;
        }
    }

    protected Class<?> getMainClass() {
        return LauncherMain.class;
    }

    public String getUpdateText() {
        return this.resources.getString("updater.launcherupdate", new String[0]);
    }

    public boolean isUpdateOnly() {
        return this.parameters.isUpdate();
    }

    public boolean isMover() {
        return (this.parameters.isMover() || this.parameters.isLegacyMover()) && !this.parameters.isLegacyLauncher();
    }

    public boolean isLauncherOnly() {
        return this.parameters.isLauncher();
    }

    public boolean isSkipUpdate() {
        return this.parameters.isSkipUpdate();
    }

    public InstallTasksQueue<Void> buildMoverTasks() {
        InstallTasksQueue<Void> queue = new InstallTasksQueue<Void>(null);
        queue.addTask(new CopyLauncherPackage(this.resources.getString("updater.mover", new String[0]), new File(this.parameters.getMoveTarget()), this));
        queue.addTask(new LaunchLauncherMode(this.resources.getString("updater.finallaunch", new String[0]), this, this.parameters.getMoveTarget(), this.parameters.isLegacyMover()));
        return queue;
    }

    public InstallTasksQueue<Void> buildUpdaterTasks() {
        this.screen = new SplashScreen(this.resources.getImage("launch_splash.png"), 30);
        Color bg = UIConstants.COLOR_FORM_ELEMENT_INTERNAL;
        this.screen.getContentPane().setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), 255));
        this.screen.getProgressBar().setForeground(Color.white);
        this.screen.getProgressBar().setBackground(UIConstants.COLOR_GREEN);
        this.screen.getProgressBar().setBackFill(UIConstants.COLOR_CENTRAL_BACK_OPAQUE);
        this.screen.getProgressBar().setFont(this.resources.getFont("OpenSans+Cyberbit.ttf", 12.0f));
        this.screen.pack();
        this.screen.setLocationRelativeTo(null);
        this.screen.setVisible(true);
        InstallTasksQueue<Void> queue = new InstallTasksQueue<Void>(this.screen.getProgressBar());
        ArrayList<IInstallTask<Void>> postDownloadTasks = new ArrayList<IInstallTask<Void>>();
        postDownloadTasks.add(new LaunchMoverMode(this.resources.getString("updater.launchmover", new String[0]), this.getTempLauncher(), this));
        TaskGroup<Void> downloadFilesGroup = new TaskGroup<Void>(this.resources.getString("updater.downloads", new String[0]));
        queue.addTask(new QueryUpdateStream(this.resources.getString("updater.query", new String[0]), this.updateStream, downloadFilesGroup, this.getFileSystem(), this, postDownloadTasks));
        queue.addTask(downloadFilesGroup);
        return queue;
    }

    public List<String> getRelaunchArgs() {
        List<String> args = this.parameters.getArgs();
        ArrayList<String> launchArgs = new ArrayList<String>(args.size() + 1);
        launchArgs.addAll(args);
        if (!launchArgs.contains("-blockReboot")) {
            launchArgs.add("-blockReboot");
        }
        return launchArgs;
    }

    public void updateComplete() {
        this.screen.dispose();
    }

    public boolean canReboot() {
        return !this.parameters.isBlockReboot();
    }

    public boolean runAutoUpdater() throws IOException, InterruptedException {
        InstallTasksQueue<Void> updateTasksQueue;
        if (this.isLauncherOnly()) {
            return true;
        }
        boolean needsReboot = false;
        if (this.canReboot()) {
            if (System.getProperty("awt.useSystemAAFontSettings") == null || !System.getProperty("awt.useSystemAAFontSettings").equals("lcd")) {
                needsReboot = true;
            } else if (!Boolean.parseBoolean(System.getProperty("java.net.preferIPv4Stack"))) {
                needsReboot = true;
            }
        }
        if (this.isMover()) {
            updateTasksQueue = this.buildMoverTasks();
        } else {
            if (needsReboot && this.getCurrentBuild() > 0) {
                this.relaunch();
                return false;
            }
            if (this.getCurrentBuild() < 1) {
                return true;
            }
            updateTasksQueue = this.buildUpdaterTasks();
        }
        if (updateTasksQueue == null) {
            return true;
        }
        updateTasksQueue.runAllTasks();
        this.updateComplete();
        return !this.didUpdate && !this.isUpdateOnly();
    }

    public void relaunch() {
        this.launch(null, this.getRelaunchArgs());
    }

    public File getTempLauncher() {
        String runningPath = this.getRunningPath();
        String extension = runningPath.endsWith(".exe") ? "exe" : "jar";
        Path destPath = this.fileSystem.getRootDirectory().resolve(String.format("temp.%s", extension));
        return destPath.toFile();
    }

    public void launch(String launchPath, List<String> args) {
        if (launchPath == null) {
            launchPath = this.getRunningPath();
        }
        ArrayList<String> commands = this.getBaseCommands(launchPath);
        commands.addAll(args);
        String commandString = String.join((CharSequence)" ", commands);
        Utils.getLogger().info(String.format("Launching command: '%s'", commandString));
        ProcessBuilder pb = ProcessUtils.createProcessBuilder(commands, true);
        try {
            pb.start();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Your OS has prevented this relaunch from completing.  You may need to add an exception in your security software.", "Relaunch Failed", 0);
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    private ArrayList<String> getBaseCommands(String launchPath) {
        ArrayList<String> commands = new ArrayList<String>();
        if (!launchPath.endsWith(".exe")) {
            commands.add(OperatingSystem.getJavaDir());
            commands.add("-Djava.net.preferIPv4Stack=true");
            commands.add("-Dawt.useSystemAAFontSettings=lcd");
            commands.add("-Dswing.aatext=true");
            commands.add("-cp");
            commands.add(launchPath);
            commands.add(this.getMainClass().getName());
        } else {
            commands.add(launchPath);
        }
        return commands;
    }

    public List<String> buildMoverArgs() {
        ArrayList<String> outArgs = new ArrayList<String>();
        outArgs.add("-movetarget");
        outArgs.add(this.getRunningPath());
        outArgs.add("-moveronly");
        outArgs.addAll(this.getRelaunchArgs());
        return outArgs;
    }

    public List<String> buildLauncherArgs(boolean isLegacy) {
        ArrayList<String> outArgs = new ArrayList<String>();
        if (!isLegacy) {
            outArgs.add("-launcheronly");
        } else {
            outArgs.add("-launcher");
        }
        Iterator<String> it = this.getRelaunchArgs().iterator();
        while (it.hasNext()) {
            String arg = it.next();
            if (arg.equals("-movetarget")) {
                if (!it.hasNext()) continue;
                it.next();
                continue;
            }
            if (arg.equals("-moveronly")) continue;
            outArgs.add(arg);
        }
        return outArgs;
    }
}

