/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.liquid;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.meta.BlockGroup;

public class LiquidBlock
extends Block {
    public TextureRegion liquidRegion;
    public TextureRegion topRegion;
    public TextureRegion bottomRegion;

    public LiquidBlock(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.hasLiquids = true;
        this.group = BlockGroup.liquids;
        this.outputsLiquid = true;
        this.envEnabled |= 6;
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.bottomRegion, this.topRegion};
    }

    public static void drawTiledFrames(int size, float x, float y, float padding, Liquid liquid, float alpha) {
        LiquidBlock.drawTiledFrames(size, x, y, padding, padding, padding, padding, liquid, alpha);
    }

    public static void drawTiledFrames(int size, float x, float y, float padLeft, float padRight, float padTop, float padBottom, Liquid liquid, float alpha) {
        TextureRegion region = Vars.renderer.fluidFrames[liquid.gas ? 1 : 0][liquid.getAnimationFrame()];
        TextureRegion toDraw = Tmp.tr1;
        float leftBounds = (float)size / 2.0f * 8.0f - padRight;
        float bottomBounds = (float)size / 2.0f * 8.0f - padTop;
        Color color = Tmp.c1.set(liquid.color).a(1.0f);
        for (int sx = 0; sx < size; ++sx) {
            for (int sy = 0; sy < size; ++sy) {
                float relx = (float)sx - (float)(size - 1) / 2.0f;
                float rely = (float)sy - (float)(size - 1) / 2.0f;
                toDraw.set(region);
                float rightBorder = relx * 8.0f + padLeft;
                float topBorder = rely * 8.0f + padBottom;
                float squishX = rightBorder + 4.0f - leftBounds;
                float squishY = topBorder + 4.0f - bottomBounds;
                float ox = 0.0f;
                float oy = 0.0f;
                if (squishX >= 8.0f || squishY >= 8.0f) continue;
                if (squishX > 0.0f) {
                    toDraw.setWidth((float)toDraw.width - squishX * 4.0f);
                    ox = -squishX / 2.0f;
                }
                if (squishY > 0.0f) {
                    toDraw.setY((float)toDraw.getY() + squishY * 4.0f);
                    oy = -squishY / 2.0f;
                }
                Drawf.liquid(toDraw, x + rightBorder + ox, y + topBorder + oy, alpha, color);
            }
        }
    }

    public class LiquidBuild
    extends Building {
        @Override
        public void draw() {
            float rotation = LiquidBlock.this.rotate ? this.rotdeg() : 0.0f;
            Draw.rect(LiquidBlock.this.bottomRegion, this.x, this.y, rotation);
            if (this.liquids.currentAmount() > 0.001f) {
                Drawf.liquid(LiquidBlock.this.liquidRegion, this.x, this.y, this.liquids.currentAmount() / LiquidBlock.this.liquidCapacity, this.liquids.current().color);
            }
            Draw.rect(LiquidBlock.this.topRegion, this.x, this.y, rotation);
        }
    }
}

