/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Nullable;
import mindustry.content.Bullets;
import mindustry.entities.Lightning;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Building;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.world.Block;

public class ShockMine
extends Block {
    public final int timerDamage;
    public float cooldown;
    public float tileDamage;
    public float damage;
    public int length;
    public int tendrils;
    public Color lightningColor;
    public int shots;
    public float inaccuracy;
    @Nullable
    public BulletType bullet;
    public float teamAlpha;
    public TextureRegion teamRegion;

    public ShockMine(String name) {
        super(name);
        this.timerDamage = this.timers++;
        this.cooldown = 80.0f;
        this.tileDamage = 5.0f;
        this.damage = 13.0f;
        this.length = 10;
        this.tendrils = 6;
        this.lightningColor = Pal.lancerLaser;
        this.shots = 6;
        this.inaccuracy = 0.0f;
        this.teamAlpha = 0.3f;
        this.update = false;
        this.destructible = true;
        this.solid = false;
        this.targetable = false;
    }

    public class ShockMineBuild
    extends Building {
        @Override
        public void drawTeam() {
        }

        @Override
        public void draw() {
            super.draw();
            Draw.color(this.team.color, ShockMine.this.teamAlpha);
            Draw.rect(ShockMine.this.teamRegion, this.x, this.y);
            Draw.color();
        }

        @Override
        public void drawCracks() {
        }

        @Override
        public void unitOn(Unit unit) {
            if (this.enabled && unit.team != this.team && this.timer(ShockMine.this.timerDamage, ShockMine.this.cooldown)) {
                this.triggered();
                this.damage(ShockMine.this.tileDamage);
            }
        }

        public void triggered() {
            int i;
            for (i = 0; i < ShockMine.this.tendrils; ++i) {
                Lightning.create(Bullets.damageLightningGround, this.team, ShockMine.this.lightningColor, ShockMine.this.damage, this.x, this.y, Mathf.random(360.0f), ShockMine.this.length);
            }
            if (ShockMine.this.bullet != null) {
                for (i = 0; i < ShockMine.this.shots; ++i) {
                    ShockMine.this.bullet.create(this, this.x, this.y, 360.0f / (float)ShockMine.this.shots * (float)i + Mathf.random(ShockMine.this.inaccuracy));
                }
            }
        }
    }
}

