/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.gl;

import arc.graphics.Gl;
import arc.graphics.gl.IndexData;
import arc.util.ArcRuntimeException;
import arc.util.Buffers;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

public class IndexBufferObjectSubData
implements IndexData {
    final ShortBuffer buffer;
    final ByteBuffer byteBuffer;
    final boolean isDirect;
    final int usage;
    int bufferHandle;
    boolean isDirty = true;
    boolean isBound = false;

    public IndexBufferObjectSubData(boolean isStatic, int maxIndices) {
        this.byteBuffer = Buffers.newByteBuffer(maxIndices * 2);
        this.isDirect = true;
        this.usage = isStatic ? 35044 : 35048;
        this.buffer = this.byteBuffer.asShortBuffer();
        this.buffer.flip();
        this.byteBuffer.flip();
        this.bufferHandle = this.createBufferObject();
    }

    public IndexBufferObjectSubData(int maxIndices) {
        this.byteBuffer = Buffers.newByteBuffer(maxIndices * 2);
        this.isDirect = true;
        this.usage = 35044;
        this.buffer = this.byteBuffer.asShortBuffer();
        this.buffer.flip();
        this.byteBuffer.flip();
        this.bufferHandle = this.createBufferObject();
    }

    private int createBufferObject() {
        int result = Gl.genBuffer();
        Gl.bindBuffer(34963, result);
        Gl.bufferData(34963, this.byteBuffer.capacity(), null, this.usage);
        Gl.bindBuffer(34963, 0);
        return result;
    }

    @Override
    public int size() {
        return this.buffer.limit();
    }

    @Override
    public int max() {
        return this.buffer.capacity();
    }

    @Override
    public void set(short[] indices, int offset, int count) {
        this.isDirty = true;
        this.buffer.clear();
        this.buffer.put(indices, offset, count);
        this.buffer.flip();
        this.byteBuffer.position(0);
        this.byteBuffer.limit(count << 1);
        if (this.isBound) {
            Gl.bufferSubData(34963, 0, this.byteBuffer.limit(), this.byteBuffer);
            this.isDirty = false;
        }
    }

    @Override
    public void set(ShortBuffer indices) {
        int pos = indices.position();
        this.isDirty = true;
        this.buffer.clear();
        this.buffer.put(indices);
        this.buffer.flip();
        indices.position(pos);
        this.byteBuffer.position(0);
        this.byteBuffer.limit(this.buffer.limit() << 1);
        if (this.isBound) {
            Gl.bufferSubData(34963, 0, this.byteBuffer.limit(), this.byteBuffer);
            this.isDirty = false;
        }
    }

    @Override
    public void update(int targetOffset, short[] indices, int offset, int count) {
        this.isDirty = true;
        int pos = this.byteBuffer.position();
        this.byteBuffer.position(targetOffset * 2);
        Buffers.copy(indices, offset, (Buffer)this.byteBuffer, count);
        this.byteBuffer.position(pos);
        this.buffer.position(0);
        if (this.isBound) {
            Gl.bufferSubData(34963, 0, this.byteBuffer.limit(), this.byteBuffer);
            this.isDirty = false;
        }
    }

    @Override
    public ShortBuffer buffer() {
        this.isDirty = true;
        return this.buffer;
    }

    @Override
    public void bind() {
        if (this.bufferHandle == 0) {
            throw new ArcRuntimeException("IndexBufferObject cannot be used after it has been disposed.");
        }
        Gl.bindBuffer(34963, this.bufferHandle);
        if (this.isDirty) {
            this.byteBuffer.limit(this.buffer.limit() * 2);
            Gl.bufferSubData(34963, 0, this.byteBuffer.limit(), this.byteBuffer);
            this.isDirty = false;
        }
        this.isBound = true;
    }

    @Override
    public void unbind() {
        Gl.bindBuffer(34963, 0);
        this.isBound = false;
    }

    @Override
    public void dispose() {
        Gl.bindBuffer(34963, 0);
        Gl.deleteBuffer(this.bufferHandle);
        this.bufferHandle = 0;
    }
}

